/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.kafka;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.imixs.workflow.kafka.ConfigService;

@Startup
@Singleton
public class ConsumerService
implements Serializable {
    private static final long TEN_SECONDS = 10000L;
    @Resource
    private TimerService timerService;
    public static String TOPIC_NAME = "IN-1.0.1";
    public static String GROUP_ID_CONFIG = "consumerGroup1";
    public static Integer MAX_NO_MESSAGE_FOUND_COUNT = 100;
    public static String OFFSET_RESET_LATEST = "latest";
    public static String OFFSET_RESET_EARLIER = "earliest";
    public static Integer MAX_POLL_RECORDS = 1;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ConsumerService.class.getName());
    Consumer<Long, String> consumer;
    Properties props = null;

    @PostConstruct
    void init() {
        TimerConfig config = new TimerConfig();
        config.setPersistent(false);
        this.timerService.createIntervalTimer(10000L, 10000L, config);
    }

    @PreDestroy
    void close() {
        if (this.consumer != null) {
            this.consumer.close();
        }
    }

    void initalizeConsumer() {
        if (this.consumer == null) {
            logger.info("......initalize kafka consumer...");
            this.props = new Properties();
            this.props.put("bootstrap.servers", ConfigService.getEnv("KAFKA_BROKERS", "kafka:9092"));
            this.props.put("group.id", GROUP_ID_CONFIG);
            this.props.put("client.id", ConfigService.getEnv("KAFKA_CLIENTID", "Imixs-Workflow-1"));
            this.props.put("key.deserializer", LongDeserializer.class.getName());
            this.props.put("value.deserializer", StringDeserializer.class.getName());
            this.props.put("max.poll.records", MAX_POLL_RECORDS);
            this.props.put("enable.auto.commit", "false");
            this.props.put("auto.offset.reset", OFFSET_RESET_EARLIER);
            this.consumer = new KafkaConsumer(this.props);
            logger.info("...register topic: " + TOPIC_NAME);
            this.consumer.subscribe(Collections.singletonList(TOPIC_NAME));
        }
    }

    @Timeout
    private synchronized void onTimer() {
        this.initalizeConsumer();
        ConsumerRecords consumerRecords = this.consumer.poll(Duration.ofMillis(1000L));
        if (consumerRecords.count() > 0) {
            consumerRecords.forEach(record -> {
                System.out.println("Record Key " + record.key());
                System.out.println("Record value " + (String)record.value());
                System.out.println("Record partition " + record.partition());
                System.out.println("Record offset " + record.offset());
            });
            this.consumer.commitAsync();
        }
    }
}

