/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.ldap;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import org.imixs.workflow.ItemCollection;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class LDAPCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(LDAPCache.class.getName());
    int DEFAULT_CACHE_SIZE = 30;
    int DEFAULT_EXPIRES_TIME = 60000;
    static final String GROUP_KEY_SUFIX = "-GROUPS";
    long expiresTime = 0L;
    long lastReset = 0L;
    Properties configurationProperties = null;
    Cache cache = null;

    @PostConstruct
    void init() {
        try {
            this.configurationProperties = new Properties();
            try {
                this.configurationProperties.load(Thread.currentThread().getContextClassLoader().getResource("imixs.properties").openStream());
            }
            catch (Exception e) {
                logger.warning("LDAPLookupService unable to find imixs.properties in current classpath");
                e.printStackTrace();
            }
            this.resetCache();
        }
        catch (Exception e) {
            logger.severe("LDAPCache unable to initalize LDAPCache");
            e.printStackTrace();
        }
    }

    public void resetCache() {
        logger.finest("......resetCache - initalizing settings....");
        int iCacheSize = this.DEFAULT_CACHE_SIZE;
        try {
            iCacheSize = Integer.valueOf(this.configurationProperties.getProperty("ldap.cache-size", "100"));
        }
        catch (NumberFormatException nfe) {
            iCacheSize = this.DEFAULT_CACHE_SIZE;
        }
        if (iCacheSize <= 0) {
            iCacheSize = this.DEFAULT_CACHE_SIZE;
        }
        this.cache = new Cache(iCacheSize);
        try {
            this.expiresTime = this.DEFAULT_EXPIRES_TIME;
            String sExpires = this.configurationProperties.getProperty("ldap.cache-expires", "600000");
            this.expiresTime = Long.valueOf(sExpires);
        }
        catch (NumberFormatException nfe) {
            this.expiresTime = this.DEFAULT_EXPIRES_TIME;
        }
        if (this.expiresTime <= 0L) {
            this.expiresTime = this.DEFAULT_EXPIRES_TIME;
        }
        logger.info("...Initialize Cache, cache-size=" + iCacheSize + " cache-expires=" + this.expiresTime + "ms");
        this.lastReset = System.currentTimeMillis();
    }

    public boolean contains(String key) {
        return this.cache.containsKey(key);
    }

    public ItemCollection getUser(String key) {
        Long now;
        if (key == null || key.isEmpty()) {
            return null;
        }
        ItemCollection user = null;
        if (this.expiresTime > 0L && (now = Long.valueOf(System.currentTimeMillis())) - this.lastReset > this.expiresTime) {
            logger.finest("......LDAPCache Cache expired!");
            this.resetCache();
            return null;
        }
        Map value = (Map)this.cache.get(key);
        if (value != null && (user = new ItemCollection(value)).getItemValueString("txtusername").trim().isEmpty()) {
            logger.warning("ISSUE #68 - getUser txtusername for '" + key + "' is empty!");
        }
        return user;
    }

    public void putUser(String key, ItemCollection user) {
        if (key == null || key.isEmpty()) {
            return;
        }
        if (user != null && user.getItemValueString("txtusername").trim().isEmpty()) {
            logger.warning("ISSUE #68 - putUser txtusername for '" + key + "' is empty!");
        }
        if (user == null) {
            logger.warning("ISSUE #68 - putUser user object for '" + key + "' is null and will not be cached!");
            return;
        }
        this.cache.put(key, user.getAllItems());
    }

    public String[] getGroups(String key) {
        Long now;
        if (key == null || key.isEmpty()) {
            return null;
        }
        if (this.expiresTime > 0L && (now = Long.valueOf(System.currentTimeMillis())) - this.lastReset > this.expiresTime) {
            logger.finest("......LDAPCache Cache expired!");
            this.resetCache();
            return null;
        }
        return (String[])this.cache.get(key + GROUP_KEY_SUFIX);
    }

    public void putGroups(String key, String[] groups) {
        if (key == null || key.isEmpty()) {
            return;
        }
        this.cache.put(key, groups + GROUP_KEY_SUFIX);
    }

    class Cache
    extends ConcurrentHashMap<String, Object>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int capacity;

        public Cache(int capacity) {
            super(capacity + 1, 1.1f);
            this.capacity = capacity;
        }

        protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
            return this.size() > this.capacity;
        }
    }
}

