/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.ldap;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.imixs.workflow.ldap.LDAPLookupService;

public class LDAPGroupInterceptor {
    @EJB
    LDAPLookupService lookupService;
    @Resource
    SessionContext ejbCtx;
    private static Logger logger = Logger.getLogger(LDAPGroupInterceptor.class.getName());

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        if (this.lookupService.isEnabled()) {
            String sMethod = ctx.getMethod().getName();
            String sUserID = this.ejbCtx.getCallerPrincipal().getName();
            if (sUserID == null || "anonymous".equals(sUserID) || sUserID.isEmpty()) {
                return ctx.proceed();
            }
            if (!ctx.getContextData().containsKey("org.imixs.USER.GROUPLIST")) {
                logger.finest("LDAPGroupInterceptor Method=" + sMethod);
                sUserID = this.ejbCtx.getCallerPrincipal().getName();
                String[] sGroups = this.lookupService.findGroups(sUserID);
                ctx.getContextData().put("org.imixs.USER.GROUPLIST", sGroups);
                if (logger.isLoggable(Level.FINEST)) {
                    String groupListe = "";
                    for (String aGroup : sGroups) {
                        groupListe = groupListe + "'" + aGroup + "' ";
                    }
                    logger.finest("resolved UserGroups for '" + sUserID + "' = " + groupListe);
                }
            }
        }
        return ctx.proceed();
    }
}

