/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.ldap;

import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.ldap.LDAPLookupService;

public class LDAPPlugin
extends AbstractPlugin {
    public static final String LDAPSERVICE_NOT_BOUND = "LDAPSERVICE_NOT_BOUND";
    public static final String PROPERTYSERVICE_NOT_BOUND = "PROPERTYSERVICE_NOT_BOUND";
    @EJB
    private LDAPLookupService ldapLokupService = null;
    private static Logger logger = Logger.getLogger(LDAPPlugin.class.getName());

    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
        if (this.ldapLokupService == null) {
            logger.finest("......LDAPLookupService not injected by CDI, trying JNDI lookup.....");
            String jndiName = "";
            try {
                InitialContext ictx = new InitialContext();
                Context ctx = (Context)ictx.lookup("java:comp/env");
                jndiName = "ejb/LDAPLookupService";
                this.ldapLokupService = (LDAPLookupService)ctx.lookup(jndiName);
                logger.finest("......LDAPLookupService JNDI lookup successfull.");
            }
            catch (NamingException e) {
                throw new PluginException(LDAPPlugin.class.getSimpleName(), LDAPSERVICE_NOT_BOUND, "Unable to lookup LDAPLookupService EJB", (Exception)e);
            }
        }
    }

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection documentActivity) throws PluginException {
        ItemCollection profile = adocumentContext;
        if ("profile".equals(profile.getItemValueString("type"))) {
            String sUserID = profile.getItemValueString("txtname");
            ItemCollection ldapUser = this.ldapLokupService.findUser(sUserID);
            if (ldapUser != null) {
                logger.fine("ldap entry found, verifing attributes...");
                Map items = ldapUser.getItemList();
                for (Map.Entry entry : items.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    logger.finest(" ...... " + key + "=" + value);
                    if (profile.getItemValue(key).equals(ldapUser.getItemValue(key))) continue;
                    profile.replaceItemValue(key, (Object)ldapUser.getItemValue(key));
                }
            } else {
                logger.warning("userid " + sUserID + " not found!");
            }
        }
        return profile;
    }
}

