/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.ldap;

import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.imixs.marty.ejb.ProfileService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.ldap.LDAPLookupService;

public class LDAPUserInterceptor {
    @EJB
    LDAPLookupService ldapLokupService;
    @EJB
    ProfileService profileService;
    @EJB
    DocumentService documentService;
    @Resource
    SessionContext ejbCtx;
    private static Logger logger = Logger.getLogger(LDAPUserInterceptor.class.getName());

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        String sMethod;
        if (this.ldapLokupService.isEnabled() && "lookupProfileById".equals(sMethod = ctx.getMethod().getName())) {
            logger.finest("......intercept method=" + sMethod);
            Object[] params = ctx.getParameters();
            String sUserID = (String)params[0];
            logger.finest("......userid=" + sUserID);
            ItemCollection profile = (ItemCollection)ctx.proceed();
            if (profile == null) {
                try {
                    profile = this.profileService.createProfile(sUserID, "");
                }
                catch (RuntimeException | ModelException | PluginException e) {
                    logger.severe("unable to create profile for userid '" + sUserID + "': " + e.getMessage());
                }
            }
            if (profile != null) {
                ItemCollection ldapUser = this.ldapLokupService.findUser(sUserID);
                boolean bUpdate = false;
                if (ldapUser != null) {
                    logger.finest("......ldap entry found, verifing attributes...");
                    Map items = ldapUser.getItemList();
                    for (Map.Entry entry : items.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        logger.finest(" ...... " + key + "=" + value);
                        if (profile.getItemValue(key).equals(ldapUser.getItemValue(key))) continue;
                        profile.replaceItemValue(key, (Object)ldapUser.getItemValue(key));
                        bUpdate = true;
                    }
                    if (bUpdate) {
                        logger.info("Updating user profile '" + sUserID + "' with new ldap attributes....");
                        profile = this.documentService.save(profile);
                    }
                } else {
                    logger.warning("userid " + sUserID + " not found!");
                }
            }
            return profile;
        }
        return ctx.proceed();
    }
}

