/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.ldap;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.imixs.marty.profile.ProfileEvent;
import org.imixs.marty.profile.ProfileService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ldap.LDAPCache;
import org.imixs.workflow.ldap.LDAPProfileEvent;

@Stateless
@LocalBean
public class LDAPLookupService {
    public static final int MAX_RESULT = 20;
    public static final int TIME_LIMIT = 20000;
    public static final String LDAP_SEARCH_CONTEXT = "ldap.search-context";
    public static final String LDAP_SEARCH_FILTER_DN = "ldap.dn-search-filter";
    public static final String LDAP_SEARCH_FILTER_GROUP = "ldap.group-search-filter";
    public static final String LDAP_SEARCH_FILTER_PHRASE = "ldap.search-filter-phrase";
    public static final String LDAP_USER_ATTRIBUTES = "ldap.user-attributes";
    private boolean enabled = false;
    private Properties configurationProperties = null;
    private String _dnSearchFilter = null;
    private String _searchFilterPhrase = null;
    private String _groupSearchFilter = null;
    private String _searchContext = null;
    private String[] userAttributesLDAP = null;
    private String[] userAttributesImixs = null;
    @Inject
    protected Event<LDAPProfileEvent> ldapProfileEvents;
    @EJB
    ProfileService profileService;
    @EJB
    LDAPCache ldapCache;
    private static Logger logger = Logger.getLogger(LDAPLookupService.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    void init() {
        try {
            logger.finest("......init lookup service");
            this.configurationProperties = new Properties();
            try {
                this.configurationProperties.load(Thread.currentThread().getContextClassLoader().getResource("imixs.properties").openStream());
            }
            catch (Exception e) {
                logger.warning("LDAPLookupService unable to find imixs.properties in current classpath");
                e.printStackTrace();
            }
            if (this.configurationProperties == null) {
                logger.severe("Missing imixs.properties!");
                return;
            }
            logger.finest("......read LDAP configuration...");
            this.setSearchContext(this.configurationProperties.getProperty(LDAP_SEARCH_CONTEXT, ""));
            if (this._searchContext.isEmpty()) {
                this.setSearchContext(this.configurationProperties.getProperty("ldap.search.context", ""));
                if (!this._searchContext.isEmpty()) {
                    logger.warning("imixs property 'ldap.search.context' is deprecated and should be replaced with 'ldap.search-context'");
                }
            }
            logger.finest("......ldap.search-context=" + this.getSearchContext());
            this.setDnSearchFilter(this.configurationProperties.getProperty(LDAP_SEARCH_FILTER_DN, "(uid=%u)"));
            logger.finest("......ldap.dn-search-filter=" + this.getDnSearchFilter());
            this.setSearchFilterPhrase(this.configurationProperties.getProperty(LDAP_SEARCH_FILTER_PHRASE, "(|(mail=?*)(cn=?*))"));
            logger.finest("......ldap.search-filter-phrase=" + this.getSearchFilterPhrase());
            this.setGroupSearchFilter(this.configurationProperties.getProperty(LDAP_SEARCH_FILTER_GROUP, "(member=%d)"));
            logger.finest("......ldap.group-search-filter=" + this.getGroupSearchFilter());
            String sAttributes = this.configurationProperties.getProperty(LDAP_USER_ATTRIBUTES, "uid,SN,CN,mail");
            logger.finest("......ldap.user-attributes=" + sAttributes);
            String[] userAttributeList = sAttributes.split(",");
            this.userAttributesLDAP = new String[userAttributeList.length];
            this.userAttributesImixs = new String[userAttributeList.length];
            for (int i = 0; i < userAttributeList.length; ++i) {
                String aAttr = userAttributeList[i].trim();
                int sPos = aAttr.indexOf(124);
                if (sPos > 0) {
                    this.userAttributesLDAP[i] = aAttr.substring(0, sPos).trim();
                    this.userAttributesImixs[i] = aAttr.substring(sPos + 1).trim();
                } else {
                    this.userAttributesLDAP[i] = aAttr;
                    this.userAttributesImixs[i] = aAttr;
                }
                logger.finest("......attributesLDAP-" + i + "=" + this.userAttributesLDAP[i]);
                logger.finest("......attributesImixs-" + i + "=" + this.userAttributesImixs[i]);
            }
            logger.finest("......verifing LDAP connection...");
            this.enabled = false;
            LdapContext ldapCtx = null;
            try {
                ldapCtx = this.getDirContext();
                this.enabled = ldapCtx != null;
            }
            finally {
                try {
                    if (ldapCtx != null) {
                        ldapCtx.close();
                        ldapCtx = null;
                    }
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
            if (this.enabled) {
                logger.fine("LDAP connection: OK");
            } else {
                logger.warning("LDAP connection: FAILED");
            }
        }
        catch (Exception e) {
            logger.severe("Unable to initalize LDAPGroupLookupService");
            e.printStackTrace();
        }
    }

    public String getDnSearchFilter() {
        return this._dnSearchFilter;
    }

    public void setDnSearchFilter(String dnSearchFilter) {
        this._dnSearchFilter = dnSearchFilter;
    }

    public String getSearchFilterPhrase() {
        return this._searchFilterPhrase;
    }

    public void setSearchFilterPhrase(String searchFilterPhrase) {
        this._searchFilterPhrase = searchFilterPhrase;
    }

    public String getGroupSearchFilter() {
        return this._groupSearchFilter;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this._groupSearchFilter = groupSearchFilter;
    }

    public String getSearchContext() {
        return this._searchContext;
    }

    public void setSearchContext(String searchContext) {
        this._searchContext = searchContext;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ItemCollection findUser(String aUID) {
        return this.findUser(aUID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCollection findUser(String aUID, boolean refresh) {
        if (aUID == null || aUID.isEmpty()) {
            return null;
        }
        if (!refresh && this.ldapCache.contains(aUID)) {
            logger.finest("......fetching user: '" + aUID + "' from cache...");
            ItemCollection user = this.ldapCache.getUser(aUID);
            if (user != null && user.getAllItems().size() > 0) {
                return user;
            }
            logger.warning("cached LDAP object expired: '" + aUID + "'");
        }
        long l = System.currentTimeMillis();
        LdapContext ldapCtx = null;
        try {
            logger.finest("......find user: '" + aUID + "'");
            ldapCtx = this.getDirContext();
            if (ldapCtx != null) {
                ItemCollection user = this.fetchUser(aUID, ldapCtx);
                if (user != null) {
                    logger.finest("......put user: '" + aUID + "' into cache.");
                    this.ldapCache.putUser(aUID, user);
                    logger.fine("... lookup user '" + aUID + "' successfull in " + (System.currentTimeMillis() - l) + "ms");
                } else {
                    logger.fine("no LDAP object found: '" + aUID + "'");
                }
                ItemCollection itemCollection = user;
                return itemCollection;
            }
            logger.warning("LDAP DirContext could not be opened!");
            ItemCollection itemCollection = null;
            return itemCollection;
        }
        finally {
            if (ldapCtx != null) {
                try {
                    ldapCtx.close();
                    ldapCtx = null;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void cacheUser(String aUID, ItemCollection user) {
        this.ldapCache.putUser(aUID, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ItemCollection> searchUserList(String searchPhrase) {
        LdapContext ldapCtx = null;
        try {
            logger.finest("......serachUserList: " + searchPhrase);
            ldapCtx = this.getDirContext();
            List<ItemCollection> list = this.fetchUserList(searchPhrase, ldapCtx);
            return list;
        }
        finally {
            if (ldapCtx != null) {
                try {
                    ldapCtx.close();
                    ldapCtx = null;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findGroups(String aUID) {
        String[] groups = this.ldapCache.getGroups(aUID);
        if (groups != null) {
            return groups;
        }
        LdapContext ldapCtx = null;
        try {
            logger.fine("find user groups for: " + aUID);
            ldapCtx = this.getDirContext();
            groups = this.fetchGroups(aUID, ldapCtx);
            if (groups == null) {
                groups = new String[]{};
            }
            if (logger.isLoggable(Level.FINE)) {
                Object groupList = "";
                for (String aGroup : groups) {
                    groupList = (String)groupList + "'" + aGroup + "' ";
                }
                logger.fine("groups found for " + aUID + "=" + (String)groupList);
            }
            this.ldapCache.putGroups(aUID, groups);
            String[] stringArray = groups;
            return stringArray;
        }
        finally {
            if (ldapCtx != null) {
                try {
                    ldapCtx.close();
                    ldapCtx = null;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCollection lookupLdapAttributes(String aUID) {
        ItemCollection user = null;
        LdapContext ldapCtx = null;
        NamingEnumeration<SearchResult> answer = null;
        String sDN = null;
        if (!this.enabled || aUID == null || aUID.isEmpty()) {
            return null;
        }
        try {
            logger.finest("......find user: '" + aUID + "'");
            ldapCtx = this.getDirContext();
            if (ldapCtx != null) {
                user = new ItemCollection();
                SearchControls ctls = new SearchControls();
                ctls.setSearchScope(2);
                String searchFilter = this.getDnSearchFilter().replace("%u", aUID);
                logger.finest("......lookup: searchContext=" + this.getSearchContext());
                logger.finest("......lookup: searchFilter=" + searchFilter);
                answer = ldapCtx.search(this.getSearchContext(), searchFilter, ctls);
                if (answer == null || !answer.hasMore()) {
                    ItemCollection itemCollection = null;
                    return itemCollection;
                }
                SearchResult entry = answer.next();
                sDN = entry.getName();
                logger.finest("......DN= " + sDN);
                Attributes attributes = entry.getAttributes();
                NamingEnumeration<? extends Attribute> ae = attributes.getAll();
                while (ae.hasMore()) {
                    Attribute attr = ae.next();
                    String itemName = attr.getID();
                    if (attr == null) continue;
                    NamingEnumeration<?> values = attr.getAll();
                    Vector valueList = new Vector();
                    while (values.hasMore()) {
                        valueList.add(values.next());
                    }
                    if (valueList.size() <= 0) continue;
                    user.replaceItemValue(itemName, valueList);
                }
                if (sDN == null) {
                    sDN = aUID;
                    user.replaceItemValue("dn", (Object)sDN);
                }
            } else {
                logger.warning("missing ldap context obejct (context==null)!");
            }
        }
        catch (NamingException e) {
            user = null;
            logger.warning("Unable to fetch DN for: " + aUID);
            logger.warning(e.getMessage());
            if (logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                    answer = null;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
            if (ldapCtx != null) {
                try {
                    ldapCtx.close();
                    ldapCtx = null;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return user;
    }

    public void onEvent(@Observes ProfileEvent event) {
        if (event.getEventType() == 1) {
            logger.finest("......intercept lookup profile method");
            String sUserID = event.getUserId();
            logger.finest("......userid=" + sUserID);
            ItemCollection ldapUser = this.findUser(sUserID);
            event.setProfile(ldapUser);
        }
        if (event.getEventType() == 2) {
            ItemCollection profile = event.getProfile();
            if (profile == null) {
                logger.severe("unable to create profile for userid '" + event.getUserId() + "' no profile object");
            } else {
                this.updateProfileLDAPData(event.getUserId(), profile);
            }
        }
    }

    public void updateProfileLDAPData(String userID, ItemCollection profile) {
        ItemCollection ldapUser = this.findUser(userID);
        boolean bUpdate = false;
        if (ldapUser != null) {
            logger.finest("......ldap entry found, verifing attributes...");
            Map items = ldapUser.getItemList();
            for (Map.Entry entry : items.entrySet()) {
                String key = (String)entry.getKey();
                if ("txtname".equalsIgnoreCase(key) || "name".equalsIgnoreCase(key)) continue;
                Object value = entry.getValue();
                logger.finest(" ...... " + key + "=" + value);
                if (profile.getItemValue(key).equals(ldapUser.getItemValue(key))) continue;
                profile.replaceItemValue(key, (Object)ldapUser.getItemValue(key));
                bUpdate = true;
            }
            if (bUpdate) {
                logger.fine("Updating user profile '" + userID + "' with new ldap attributes....");
            }
        } else {
            logger.warning("userid " + userID + " not found!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ItemCollection fetchUser(String aUID, LdapContext ldapCtx) {
        user = null;
        sDN = null;
        if (!this.enabled || aUID == null || aUID.isEmpty()) {
            return null;
        }
        if (ldapCtx != null) {
            answer = null;
            try {
                user = new ItemCollection();
                ctls = new SearchControls();
                ctls.setSearchScope(2);
                ctls.setReturningAttributes(this.userAttributesLDAP);
                searchFilter = this.getDnSearchFilter().replace("%u", aUID);
                LDAPLookupService.logger.finest("......fetchUser: searchContext=" + this.getSearchContext());
                LDAPLookupService.logger.finest("......fetchUser: searchFilter=" + searchFilter);
                answer = ldapCtx.search(this.getSearchContext(), searchFilter, ctls);
                if (answer == null || !answer.hasMore()) {
                    var8_11 = null;
                    return var8_11;
                }
                entry = answer.next();
                sDN = entry.getName();
                LDAPLookupService.logger.finest("......DN= " + sDN);
                attributes = entry.getAttributes();
                for (i = 0; i < this.userAttributesLDAP.length; ++i) {
                    atr = attributes.get(this.userAttributesLDAP[i]);
                    LDAPLookupService.logger.finest("......fetch attribute: '" + this.userAttributesLDAP[i] + "' = " + atr);
                    if (atr == null) continue;
                    values = atr.getAll();
                    valueList = new Vector<?>();
                    while (values.hasMore()) {
                        valueList.add(values.next());
                    }
                    if (valueList.size() <= 0) continue;
                    user.replaceItemValue(this.userAttributesImixs[i], valueList);
                }
                if (sDN != null) ** GOTO lbl57
                sDN = aUID;
                user.replaceItemValue("dn", (Object)sDN);
            }
            catch (NamingException e) {
                user = null;
                LDAPLookupService.logger.warning("Unable to fetch DN for: " + aUID);
                LDAPLookupService.logger.warning(e.getMessage());
                if (!LDAPLookupService.logger.isLoggable(Level.FINEST)) ** GOTO lbl57
                e.printStackTrace();
            }
            finally {
                if (answer != null) {
                    try {
                        answer.close();
                        answer = null;
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            LDAPLookupService.logger.warning("missing ldap context obejct (context==null)!");
        }
lbl57:
        // 5 sources

        if (this.ldapProfileEvents != null) {
            if (user != null) {
                event = new LDAPProfileEvent(user);
                this.ldapProfileEvents.fire((Object)event);
                newUserObject = event.getProfile();
                if (newUserObject != null) {
                    user = newUserObject;
                } else {
                    LDAPLookupService.logger.warning("LDAPProfileEvent returned a null object for '" + aUID + "'");
                }
            }
        } else {
            LDAPLookupService.logger.warning("CDI Support is missing - LDAPProfileEvent wil not be fired");
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ItemCollection> fetchUserList(String searchPhrase, LdapContext ldapCtx) {
        NamingEnumeration<SearchResult> answer = null;
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        if (searchPhrase == null || searchPhrase.isEmpty()) {
            return result;
        }
        long l = System.currentTimeMillis();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(this.userAttributesLDAP);
            ctls.setCountLimit(20L);
            ctls.setTimeLimit(20000);
            String searchFilter = this.getSearchFilterPhrase().replace("?", searchPhrase);
            logger.finest("......fetchUser: searchFilter = " + searchFilter);
            answer = ldapCtx.search(this.getSearchContext(), searchFilter, ctls);
            if (answer == null) {
                logger.finest("......search returend null");
                ArrayList<ItemCollection> arrayList = result;
                return arrayList;
            }
            logger.finest("......computing result list...");
            while (answer.hasMore()) {
                SearchResult entry = answer.next();
                ItemCollection itemColUser = new ItemCollection();
                String sDN = entry.getName();
                logger.finest("......DN = " + sDN);
                Attributes attributes = entry.getAttributes();
                for (int i = 0; i < this.userAttributesLDAP.length; ++i) {
                    Attribute atr = attributes.get(this.userAttributesLDAP[i]);
                    if (atr == null) continue;
                    NamingEnumeration<?> values = atr.getAll();
                    Vector valueList = new Vector();
                    while (values.hasMore()) {
                        valueList.add(values.next());
                    }
                    if (valueList.size() <= 0) continue;
                    itemColUser.replaceItemValue(this.userAttributesImixs[i], valueList);
                }
                if (this.ldapProfileEvents != null) {
                    LDAPProfileEvent event = new LDAPProfileEvent(itemColUser);
                    this.ldapProfileEvents.fire((Object)event);
                    itemColUser = event.getProfile();
                } else {
                    logger.warning("CDI Support is missing - LDAPProfileEvent wil not be fired");
                }
                result.add(itemColUser);
                if (result.size() < 20) continue;
                break;
            }
        }
        catch (NamingException e) {
            logger.warning("ldap search error: " + e.getMessage());
            if (logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                    answer = null;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        logger.fine("......search returend " + result.size() + " entries in " + (System.currentTimeMillis() - l) + "ms");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] fetchGroups(String aUID, LdapContext ldapCtx) {
        String sDN = null;
        Vector<String> vGroupList = null;
        String[] groupArrayList = null;
        if (!this.enabled || aUID == null || aUID.isEmpty()) {
            return null;
        }
        NamingEnumeration<SearchResult> answer = null;
        try {
            vGroupList = new Vector<String>();
            String groupNamePraefix = this.configurationProperties.getProperty("group-name-praefix");
            ItemCollection user = this.fetchUser(aUID, ldapCtx);
            if (user == null) {
                String[] stringArray = null;
                return stringArray;
            }
            sDN = user.getItemValueString("dn");
            logger.finest("......fetchGroups for: " + sDN);
            String[] returnedAtts = new String[]{"cn"};
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(returnedAtts);
            String searchFilter = this.getGroupSearchFilter().replace("%d", sDN);
            logger.finest("......groupSearchFilter:" + searchFilter);
            answer = ldapCtx.search(this.getSearchContext(), searchFilter, ctls);
            if (answer == null) {
                String[] stringArray = null;
                return stringArray;
            }
            while (answer.hasMore()) {
                SearchResult entry = answer.next();
                String sGroupName = entry.getName();
                if ((sGroupName = sGroupName.substring(3)).indexOf(44) > -1) {
                    sGroupName = sGroupName.substring(0, sGroupName.indexOf(44));
                }
                if (groupNamePraefix != null && !"".equals(groupNamePraefix) && !sGroupName.startsWith(groupNamePraefix)) continue;
                logger.finest("......found Group= " + sGroupName);
                vGroupList.add(sGroupName);
            }
            logger.finest("......found " + vGroupList.size() + " groups");
            groupArrayList = new String[vGroupList.size()];
            vGroupList.toArray(groupArrayList);
            logger.finest("......put groups into cache for '" + aUID + "'");
        }
        catch (NamingException e) {
            groupArrayList = null;
            logger.warning("Unable to fetch groups for: " + aUID);
            if (logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                    answer = null;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return groupArrayList;
    }

    private LdapContext getDirContext() {
        LdapContext ldapCtx;
        block7: {
            String ldapJndiName = null;
            ldapCtx = null;
            long l = System.currentTimeMillis();
            if (this.configurationProperties == null) {
                return null;
            }
            try {
                InitialContext initCtx = new InitialContext();
                String sDisabled = this.configurationProperties.getProperty("ldap.disable-jndi");
                logger.finest("......ldap.disable-jndi=" + sDisabled);
                if (sDisabled != null && "true".equals(sDisabled.toLowerCase())) {
                    logger.finest("......jndi lookup LdapContext.....");
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    Enumeration<Object> keys = this.configurationProperties.keys();
                    while (keys.hasMoreElements()) {
                        String sKey = keys.nextElement().toString();
                        if (!sKey.startsWith("java.naming")) continue;
                        env.put(sKey, this.configurationProperties.getProperty(sKey));
                        logger.finest("......Set env key: " + sKey + "=" + this.configurationProperties.getProperty(sKey));
                    }
                    env.put("java.naming.factory.initial", this.configurationProperties.getProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory"));
                    env.put("java.naming.security.authentication", this.configurationProperties.getProperty("java.naming.security.authentication", "simple"));
                    ldapCtx = new InitialLdapContext(env, null);
                    logger.finest("......jndi lookup LdapContext successful! ");
                } else {
                    ldapJndiName = this.configurationProperties.getProperty("ldap.jndi-name");
                    if ("".equals(ldapJndiName)) {
                        ldapJndiName = "org.imixs.office.ldap";
                    }
                    logger.finest("......lookup LDAP Ctx from pool '" + ldapJndiName + "' .....");
                    ldapCtx = (LdapContext)initCtx.lookup(ldapJndiName);
                }
                logger.fine("......LdapContext initialized in " + (System.currentTimeMillis() - l) + " ms");
            }
            catch (NamingException e) {
                logger.severe("Failed to open ldap conntext: " + e.getMessage());
                if (!logger.isLoggable(Level.FINE)) break block7;
                e.printStackTrace();
            }
        }
        return ldapCtx;
    }
}

