/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.ldap;

import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.SessionContext;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ldap.LDAPLookupService;

public class LDAPGroupInterceptor {
    @EJB
    LDAPLookupService lookupService;
    @Resource
    SessionContext ejbCtx;
    private static Logger logger = Logger.getLogger(LDAPGroupInterceptor.class.getName());

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        if (this.lookupService.isEnabled()) {
            String sMethod = ctx.getMethod().getName();
            String sUserID = this.ejbCtx.getCallerPrincipal().getName();
            if (sUserID == null || "anonymous".equals(sUserID) || sUserID.isEmpty()) {
                return ctx.proceed();
            }
            if (!ctx.getContextData().containsKey("org.imixs.USER.GROUPLIST")) {
                logger.finest("LDAPGroupInterceptor Method=" + sMethod);
                sUserID = this.ejbCtx.getCallerPrincipal().getName();
                String[] sGroups = this.lookupService.findGroups(sUserID);
                ctx.getContextData().put("org.imixs.USER.GROUPLIST", sGroups);
                if (logger.isLoggable(Level.FINEST)) {
                    Object groupListe = "";
                    for (String aGroup : sGroups) {
                        groupListe = (String)groupListe + "'" + aGroup + "' ";
                    }
                    logger.finest("resolved UserGroups for '" + sUserID + "' = " + (String)groupListe);
                }
            }
        }
        return ctx.proceed();
    }
}

