/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.ldap;

import jakarta.ejb.EJB;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.marty.profile.ProfileService;
import org.imixs.marty.profile.UserInputController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.ldap.LDAPLookupService;

@Named(value="userInputController")
@Alternative
@SessionScoped
public class LDAPUserInputController
extends UserInputController {
    private static final long serialVersionUID = 1L;
    @EJB
    protected LDAPLookupService ldapLookupService;
    @EJB
    protected ProfileService profileService;
    private static Logger logger = Logger.getLogger(LDAPUserInputController.class.getName());

    public List<ItemCollection> searchProfile(String phrase) {
        ArrayList<ItemCollection> searchResult = new ArrayList<ItemCollection>();
        if (phrase == null || phrase.isEmpty()) {
            return searchResult;
        }
        if (!this.ldapLookupService.isEnabled()) {
            return super.searchProfile(phrase);
        }
        List<ItemCollection> result = this.ldapLookupService.searchUserList(phrase);
        logger.fine("...found " + result.size() + " user objects...");
        return result;
    }

    public List<ItemCollection> getSortedProfilelist(List<Object> aNameList) {
        ArrayList<ItemCollection> profiles = new ArrayList<ItemCollection>();
        if (aNameList == null) {
            return profiles;
        }
        for (Object aentry : aNameList) {
            if (aentry == null || aentry.toString().isEmpty()) continue;
            ItemCollection profile = null;
            profile = !this.ldapLookupService.isEnabled() ? this.profileService.findProfileById(aentry.toString()) : this.ldapLookupService.findUser(aentry.toString());
            if (profile != null) {
                profile.setItemValue("txtname", (Object)aentry.toString());
                profiles.add(profile);
                continue;
            }
            profile = new ItemCollection();
            profile.replaceItemValue("txtName", (Object)aentry.toString());
            profile.replaceItemValue("txtUserName", (Object)aentry.toString());
            profiles.add(profile);
        }
        Collections.sort(profiles, new ItemCollectionComparator("txtUserName", true));
        return profiles;
    }
}

