/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.odf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.imixs.archive.core.SnapshotService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.util.XMLParser;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.incubator.search.InvalidNavigationException;
import org.odftoolkit.odfdom.incubator.search.TextNavigation;
import org.odftoolkit.odfdom.incubator.search.TextSelection;

public class ODFDOMFindReplaceAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(ODFDOMFindReplaceAdapter.class.getName());
    public static final String DOCUMENT_ERROR = "DOCUMENT_ERROR";
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    @Inject
    WorkflowService workflowService;
    @Inject
    SnapshotService snapshotService;
    @Inject
    ReportService reportService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException, PluginException {
        ItemCollection odfConfig = this.workflowService.evalWorkflowResult(event, "odf-update", document, false);
        if (odfConfig == null || !odfConfig.hasItem("findreplace")) {
            throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong odf configuration");
        }
        String fileName = odfConfig.getItemValueString("filename");
        if (!(fileName = this.workflowService.adaptText(fileName, document)).toLowerCase().endsWith(".odt") && !fileName.toLowerCase().endsWith(".ods")) {
            throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "Only .odt, .ods files are supported!");
        }
        List replaceDevList = odfConfig.getItemValue("findreplace");
        String eval = odfConfig.getItemValueString("eval");
        if (replaceDevList.size() == 0) {
            throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong odf configuration");
        }
        logger.info("...starting update file: " + fileName + "...");
        boolean foundFile = false;
        FileData fileData = document.getFileData(fileName);
        if (fileData != null) {
            foundFile = true;
            this.updateFileData(fileData, document, replaceDevList, eval);
        } else {
            List fileNames = document.getFileNames();
            Pattern pattern = Pattern.compile(fileName);
            for (String aFileName : fileNames) {
                if (!pattern.matcher(aFileName).find() || (fileData = document.getFileData(aFileName)) == null) continue;
                foundFile = true;
                this.updateFileData(fileData, document, replaceDevList, eval);
            }
        }
        if (!foundFile) {
            throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong odf configuration - no file found matching '" + fileName + "' !");
        }
        return document;
    }

    public void updateFileData(FileData fileData, ItemCollection document, List<String> replaceDevList, String eval) throws PluginException {
        byte[] newContent = null;
        logger.info("....updateFileData - file=" + fileData.getName());
        String fileName = fileData.getName();
        if (fileData.getContent() == null || fileData.getContent().length < 3) {
            fileData = this.snapshotService.getWorkItemFile(document.getUniqueID(), fileName);
        }
        if (fileName.toLowerCase().endsWith(".odt")) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileData.getContent());){
                OdfTextDocument doc = (OdfTextDocument)OdfDocument.loadDocument((InputStream)inputStream);
                logger.fine("OdfDocument loaded");
                for (String entityDev : replaceDevList) {
                    ItemCollection entityData = XMLParser.parseItemStructure((String)entityDev);
                    if (entityData == null) continue;
                    String find = entityData.getItemValueString("find");
                    find = this.workflowService.adaptText(find, document);
                    String replace = entityData.getItemValueString("replace");
                    replace = this.workflowService.adaptText(replace, document);
                    this.replaceODFDocument(doc, find, replace);
                }
                logger.fine("findreplace completed");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                doc.save((OutputStream)byteArrayOutputStream);
                doc.close();
                newContent = byteArrayOutputStream.toByteArray();
            }
            catch (Exception e) {
                logger.warning("Failed to convert document: " + e.getMessage());
                throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), DOCUMENT_ERROR, "unable to update document '" + fileName + "': " + e.getMessage());
            }
            FileData fileDataNew = new FileData(fileData.getName(), newContent, fileData.getContentType(), null);
            document.addFileData(fileDataNew);
            logger.fine("new document added");
        }
    }

    private void replaceODFDocument(OdfTextDocument doc, String pattern, String replace) throws InvalidNavigationException {
        TextNavigation searchPattern = new TextNavigation(pattern, doc);
        while (searchPattern.hasNext()) {
            logger.fine("..found match!");
            TextSelection textSelection = (TextSelection)searchPattern.getCurrentItem();
            textSelection.replaceWith(replace);
        }
    }
}

