/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.odf;

import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.archive.core.SnapshotService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.util.XMLParser;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.incubator.search.InvalidNavigationException;
import org.odftoolkit.odfdom.incubator.search.TextNavigation;
import org.odftoolkit.odfdom.incubator.search.TextSelection;

public class ODFDOMFindReplaceAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(ODFDOMFindReplaceAdapter.class.getName());
    public static final String DOCUMENT_ERROR = "DOCUMENT_ERROR";
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    @Inject
    WorkflowService workflowService;
    @Inject
    SnapshotService snapshotService;
    @Inject
    ReportService reportService;

    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        boolean isDeprecated = false;
        ItemCollection evalItemCollection = null;
        ArrayList<ItemCollection> odfUpdateConfigList = null;
        isDeprecated = this.isDeprecatedConfiguration(workitem, event);
        if (isDeprecated) {
            logger.warning("WopiTemplateAdapter is using deprecated configuration! Please use <odf-update> instead of <odf-update name='find-replace'>  - see documentation for details!");
            evalItemCollection = this.workflowService.evalWorkflowResult(event, "odf-update", workitem, false);
            odfUpdateConfigList = new ArrayList<ItemCollection>();
            odfUpdateConfigList.add(evalItemCollection);
        } else {
            String workflowResult = event.getItemValueString("txtActivityResult");
            odfUpdateConfigList = XMLParser.parseTagList((String)workflowResult, (String)"odf-update");
        }
        if (odfUpdateConfigList == null || odfUpdateConfigList.size() == 0) {
            throw new ProcessingErrorException(ODFDOMFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "missing odf-update configuraiton in BPMN event!");
        }
        for (ItemCollection odfUpdateConfig : odfUpdateConfigList) {
            String fileName = odfUpdateConfig.getItemValueString("filename");
            if (!(fileName = this.workflowService.adaptText(fileName, workitem)).toLowerCase().endsWith(".odt") && !fileName.toLowerCase().endsWith(".ods")) {
                throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "Only .odt, .ods files are supported!");
            }
            List replaceDevList = null;
            replaceDevList = isDeprecated ? odfUpdateConfig.getItemValue("findreplace") : odfUpdateConfig.getItemValue("replace");
            if (replaceDevList.size() == 0) {
                throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "Wrong odf configuration - missing <replace> tag! Verify BPMN event confiuration!");
            }
            boolean foundFile = false;
            FileData fileData = workitem.getFileData(fileName);
            if (fileData != null) {
                foundFile = true;
                this.updateFileData(fileData, workitem, replaceDevList);
            } else {
                List fileNames = workitem.getFileNames();
                Pattern pattern = Pattern.compile(fileName);
                for (String aFileName : fileNames) {
                    if (!pattern.matcher(aFileName).find() || (fileData = workitem.getFileData(aFileName)) == null) continue;
                    foundFile = true;
                    this.updateFileData(fileData, workitem, replaceDevList);
                }
            }
            if (foundFile) continue;
            throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong odf configuration - no file found matching '" + fileName + "' !");
        }
        return workitem;
    }

    public void updateFileData(FileData fileData, ItemCollection workitem, List<String> replaceDevList) throws PluginException {
        byte[] newContent = null;
        logger.info("....updateFileData - file=" + fileData.getName());
        String fileName = fileData.getName();
        if (fileData.getContent() == null || fileData.getContent().length < 3) {
            fileData = this.snapshotService.getWorkItemFile(workitem.getUniqueID(), fileName);
        }
        OdfDocument odfDoc = this.loadODFDocument(fileData);
        logger.fine("OdfTextDocument loaded");
        try {
            this.updateODFDocument(odfDoc, workitem, replaceDevList);
            logger.fine("findreplace completed");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            odfDoc.save((OutputStream)byteArrayOutputStream);
            odfDoc.close();
            newContent = byteArrayOutputStream.toByteArray();
            FileData fileDataNew = new FileData(fileData.getName(), newContent, fileData.getContentType(), null);
            workitem.addFileData(fileDataNew);
            logger.fine("new document added");
        }
        catch (Exception e) {
            throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), DOCUMENT_ERROR, "unable to updated document '" + fileName + "' : " + e.getMessage());
        }
    }

    public OdfDocument loadODFDocument(FileData fileData) throws PluginException {
        String fileName = fileData.getName();
        if (fileData.getContent() == null || fileData.getContent().length < 5) {
            throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), DOCUMENT_ERROR, "unable to load document '" + fileName + "' - no file content found!");
        }
        if (fileName.toLowerCase().endsWith(".odt") || fileName.toLowerCase().endsWith(".ods")) {
            OdfDocument odfDocument;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileData.getContent());
            try {
                OdfDocument odfDoc = OdfDocument.loadDocument((InputStream)inputStream);
                logger.fine("OdfTextDocument loaded");
                odfDocument = odfDoc;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warning("Failed to convert document: " + e.getMessage());
                    throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), DOCUMENT_ERROR, "unable to update document '" + fileName + "': " + e.getMessage());
                }
            }
            ((InputStream)inputStream).close();
            return odfDocument;
        }
        throw new PluginException(ODFDOMFindReplaceAdapter.class.getSimpleName(), DOCUMENT_ERROR, "unsupported file format (.odt or .ods expected)!");
    }

    public void updateODFDocument(OdfDocument odfDoc, ItemCollection workitem, List<String> replaceDevList) throws PluginException, InvalidNavigationException {
        logger.fine("OdfTextDocument loaded");
        for (String entityDev : replaceDevList) {
            ItemCollection entityData = XMLParser.parseItemStructure((String)entityDev);
            if (entityData == null) continue;
            String key = entityData.getItemValueString("key");
            if (entityData.hasItem("find")) {
                key = entityData.getItemValueString("find");
            }
            String value = entityData.getItemValueString("value");
            if (entityData.hasItem("replace")) {
                value = entityData.getItemValueString("replace");
            }
            key = key.trim();
            value = value.trim();
            key = this.workflowService.adaptText(key, workitem);
            value = this.workflowService.adaptText(value, workitem);
            if (odfDoc instanceof OdfTextDocument) {
                this.replaceODFTextFragment((OdfTextDocument)odfDoc, key, value);
            }
            if (!(odfDoc instanceof OdfSpreadsheetDocument)) continue;
            OdfTable table = (OdfTable)odfDoc.getTableList(true).get(0);
            this.replaceODFCell((OdfSpreadsheetDocument)odfDoc, table, key, value);
        }
    }

    private void replaceODFTextFragment(OdfTextDocument doc, String pattern, String replace) throws InvalidNavigationException {
        logger.finest("..test for pattern:  " + pattern + "    ---> Replace: " + replace);
        TextNavigation textNavigator = new TextNavigation(pattern, doc);
        while (textNavigator.hasNext()) {
            TextSelection selection = textNavigator.next();
            selection.replaceWith(replace);
        }
    }

    private void replaceODFCell(OdfSpreadsheetDocument doc, OdfTable table, String address, String replace) throws InvalidNavigationException {
        OdfTableCell cell = table.getCellByPosition(address);
        cell.setStringValue(replace);
    }

    private boolean isDeprecatedConfiguration(ItemCollection workitem, ItemCollection event) throws PluginException {
        String workflowResult = event.getItemValueString("txtActivityResult");
        return !workflowResult.contains("<odf-update>");
    }
}

