/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.poi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.imixs.archive.core.SnapshotService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.poi.POIFindReplaceAdapter;
import org.imixs.workflow.util.XMLParser;

public class POICopyContentAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(POICopyContentAdapter.class.getName());
    public static final String DOCUMENT_ERROR = "DOCUMENT_ERROR";
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    @Inject
    WorkflowService workflowService;
    @Inject
    SnapshotService snapshotService;
    @Inject
    ReportService reportService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException, PluginException {
        ItemCollection poiConfig = this.workflowService.evalWorkflowResult(event, "poi-copy", document, false);
        if (poiConfig == null || !poiConfig.hasItem("copy")) {
            throw new PluginException(POICopyContentAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong poi configuration");
        }
        String fileName = poiConfig.getItemValueString("filename");
        if (!(fileName = this.workflowService.adaptText(fileName, document)).toLowerCase().endsWith(".xls") && !fileName.toLowerCase().endsWith(".xlsx")) {
            throw new PluginException(POICopyContentAdapter.class.getSimpleName(), CONFIG_ERROR, "Only .xls and .xlsx files are supported!");
        }
        List copyList = poiConfig.getItemValue("copy");
        if (copyList.size() == 0) {
            throw new PluginException(POICopyContentAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong poi configuration - missing 'copy' definition");
        }
        logger.fine("......starting copy file data from: " + fileName + "...");
        try {
            boolean foundFile = false;
            FileData fileData = document.getFileData(fileName);
            if (fileData != null) {
                foundFile = true;
                this.copyFileData(fileData, document, copyList);
            } else {
                List fileNames = document.getFileNames();
                Pattern pattern = Pattern.compile(fileName);
                for (String aFileName : fileNames) {
                    if (!pattern.matcher(aFileName).find() || (fileData = document.getFileData(aFileName)) == null) continue;
                    foundFile = true;
                    this.copyFileData(fileData, document, copyList);
                }
            }
            if (!foundFile) {
                throw new PluginException(POICopyContentAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong poi configuration - no file found matching '" + fileName + "' !");
            }
        }
        catch (IOException e) {
            throw new PluginException(POICopyContentAdapter.class.getSimpleName(), DOCUMENT_ERROR, "doucment '" + fileName + "' not readable: " + e.getMessage());
        }
        return document;
    }

    void copyFileData(FileData fileData, ItemCollection document, List<String> itemList) throws IOException, PluginException {
        String fileName = fileData.getName();
        if (fileData.getContent() == null || fileData.getContent().length < 3) {
            fileData = this.snapshotService.getWorkItemFile(document.getUniqueID(), fileName);
        }
        ByteArrayInputStream imputStream = new ByteArrayInputStream(fileData.getContent());
        if (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx")) {
            XSSFWorkbook doc = new XSSFWorkbook((InputStream)imputStream);
            logger.info("XSSFWorkbook loaded");
            XSSFSheet sheet = doc.getSheetAt(0);
            for (String entityDev : itemList) {
                ItemCollection entityData = XMLParser.parseItemStructure((String)entityDev);
                if (entityData == null) continue;
                String find = entityData.getItemValueString("find");
                String item = entityData.getItemValueString("itemname");
                String type = entityData.getItemValueString("type");
                Object o = this.findCellValueXSSFSheet(doc, sheet, find, type);
                document.setItemValue(item, o);
            }
            logger.fine("copy completed");
            doc.close();
        }
    }

    private Object findCellValueXSSFSheet(XSSFWorkbook doc, XSSFSheet sheet, String cellName, String type) throws PluginException {
        XSSFCell cell;
        logger.finest("find cell " + cellName);
        XSSFName aNamedCell = doc.getName(cellName);
        if (aNamedCell != null) {
            logger.info("...resolving named cell = " + aNamedCell.getNameName());
            cellName = aNamedCell.getRefersToFormula();
            logger.info("...cell = " + cellName);
        }
        if ((cell = POIFindReplaceAdapter.getCellByRef(sheet, cellName)) != null) {
            try {
                Object cellValue = "date".equalsIgnoreCase(type) ? cell.getDateCellValue() : ("number".equalsIgnoreCase(type) ? Double.valueOf(cell.getNumericCellValue()) : cell.getStringCellValue());
                return cellValue;
            }
            catch (Exception e) {
                logger.warning("failed to read cell value: " + e.getMessage());
            }
        } else {
            logger.warning("......cell " + cellName + " not found! Please check your configuration.");
        }
        return null;
    }
}

