/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.poi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.exceptions.QueryException;

@Path(value="/poi")
@Produces(value={"application/xml", "application/json", "text/html", "text/xml"})
@Stateless
public class SpreadsheetRestService {
    @Inject
    private ReportService reportService;
    @Context
    private HttpServletRequest servletRequest;
    private static Logger logger = Logger.getLogger(SpreadsheetRestService.class.getName());

    @GET
    @Produces(value={"application/vnd.ms-excel"})
    @Path(value="report/{name}.xlsx")
    public Response getPOIResult(@PathParam(value="name") String reportName, @DefaultValue(value="1000") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo, @Context HttpServletResponse servlerResponse) {
        List data = null;
        try {
            ItemCollection report = this.reportService.findReport(reportName);
            if (report == null) {
                logger.warning("report " + reportName + " not found.");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            List attributes = report.getItemValue("attributes");
            ArrayList<String> items = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            for (List attribute : attributes) {
                items.add((String)attribute.get(0));
                String label = (String)attribute.get(0);
                if (attribute.size() >= 2 && !((String)attribute.get(1)).isEmpty()) {
                    label = (String)attribute.get(1);
                }
                labels.add(label);
            }
            Map<String, String> params = this.getQueryParams(uriInfo);
            data = this.reportService.getDataSource(report, pageSize, pageIndex, sortBy, sortReverse, params);
            FileData fileData = this.buildExceObject(data, items, labels, reportName + ".xlsx");
            if (fileData != null) {
                Response.ResponseBuilder builder = Response.ok((Object)fileData.getContent(), (String)fileData.getContentType());
                return builder.build();
            }
            logger.warning("unable to open excel file");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IOException | QueryException e) {
            logger.severe("unable to generate excel file - error: " + e.getMessage());
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    private FileData buildExceObject(List<ItemCollection> data, List<String> items, List<String> labels, String filename) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("Workflow Data");
        XSSFCellStyle cellStyleBold = workbook.createCellStyle();
        XSSFFont font = workbook.createFont();
        font.setBold(true);
        cellStyleBold.setFont((Font)font);
        XSSFCellStyle cellStyleDate = workbook.createCellStyle();
        XSSFCreationHelper createHelper = workbook.getCreationHelper();
        cellStyleDate.setDataFormat(createHelper.createDataFormat().getFormat("m/d/yy h:mm"));
        int rowNum = 0;
        logger.finest("Creating excel");
        XSSFRow row = sheet.createRow(rowNum++);
        row.setRowStyle((CellStyle)cellStyleBold);
        int colNum = 0;
        for (String label : labels) {
            Cell cell = row.createCell(colNum++);
            cell.setCellValue(label);
        }
        for (ItemCollection doc : data) {
            row = sheet.createRow(rowNum++);
            colNum = 0;
            for (String item : items) {
                String value = null;
                List valueList = doc.getItemValue(item);
                if (valueList == null || valueList.size() == 0) {
                    value = "";
                } else {
                    value = valueList.get(0);
                    if (value == null) {
                        value = "";
                    }
                }
                Cell cell = row.createCell(colNum++);
                if (value instanceof Integer) {
                    cell.setCellValue((double)((Integer)((Object)value)).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    cell.setCellValue((double)((Long)((Object)value)).longValue());
                    continue;
                }
                if (value instanceof Float) {
                    cell.setCellValue((double)((Float)((Object)value)).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    cell.setCellValue(((Double)((Object)value)).doubleValue());
                    continue;
                }
                if (value instanceof Date) {
                    cell.setCellValue((Date)((Object)value));
                    cell.setCellStyle((CellStyle)cellStyleDate);
                    continue;
                }
                cell.setCellValue(value);
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        workbook.write((OutputStream)out);
        workbook.close();
        byte[] content = out.toByteArray();
        FileData fileData = new FileData(filename, content, "application/vnd.ms-excel", null);
        out.close();
        return fileData;
    }

    private Map<String, String> getQueryParams(UriInfo uriInfo) {
        MultivaluedMap mvm = uriInfo.getQueryParameters();
        HashMap<String, String> result = new HashMap<String, String>();
        Set keys = mvm.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String sKeyName = ((String)iter.next()).toString();
            result.put(sKeyName, (String)mvm.getFirst((Object)sKeyName));
        }
        return result;
    }
}

