/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.poi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.imixs.archive.core.SnapshotService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.util.XMLParser;

public class POIFindReplaceAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(POIFindReplaceAdapter.class.getName());
    public static final String DOCUMENT_ERROR = "DOCUMENT_ERROR";
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    @Inject
    WorkflowService workflowService;
    @Inject
    SnapshotService snapshotService;
    @Inject
    ReportService reportService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException, PluginException {
        ItemCollection poiConfig = this.workflowService.evalWorkflowResult(event, "poi-update", document, false);
        if (poiConfig == null || !poiConfig.hasItem("findreplace")) {
            throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong poi configuration");
        }
        String fileName = poiConfig.getItemValueString("filename");
        if (!((fileName = this.workflowService.adaptText(fileName, document)).toLowerCase().endsWith(".docx") || fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx"))) {
            throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "Only .docx, .xls and .xlsx files are supported!");
        }
        List replaceDevList = poiConfig.getItemValue("findreplace");
        String eval = poiConfig.getItemValueString("eval");
        if (replaceDevList.size() == 0) {
            throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong poi configuration");
        }
        logger.fine("......starting update file: " + fileName + "...");
        try {
            boolean foundFile = false;
            FileData fileData = document.getFileData(fileName);
            if (fileData != null) {
                foundFile = true;
                this.updateFileData(fileData, document, replaceDevList, eval);
            } else {
                List fileNames = document.getFileNames();
                Pattern pattern = Pattern.compile(fileName);
                for (String aFileName : fileNames) {
                    if (!pattern.matcher(aFileName).find() || (fileData = document.getFileData(aFileName)) == null) continue;
                    foundFile = true;
                    this.updateFileData(fileData, document, replaceDevList, eval);
                }
            }
            if (!foundFile) {
                throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong poi configuration - no file found matching '" + fileName + "' !");
            }
        }
        catch (IOException e) {
            throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), DOCUMENT_ERROR, "doucment '" + fileName + "' not readable: " + e.getMessage());
        }
        return document;
    }

    public void updateFileData(FileData fileData, ItemCollection document, List<String> replaceDevList, String eval) throws IOException, PluginException {
        XWPFDocument doc;
        byte[] newContent = null;
        String fileName = fileData.getName();
        if (fileData.getContent() == null || fileData.getContent().length < 3) {
            fileData = this.snapshotService.getWorkItemFile(document.getUniqueID(), fileName);
        }
        ByteArrayInputStream imputStream = new ByteArrayInputStream(fileData.getContent());
        if (fileName.toLowerCase().endsWith(".docx")) {
            doc = new XWPFDocument((InputStream)imputStream);
            logger.fine("XWPFDocument loaded");
            for (String string : replaceDevList) {
                ItemCollection entityData = XMLParser.parseItemStructure((String)string);
                if (entityData == null) continue;
                String find = entityData.getItemValueString("find");
                find = this.workflowService.adaptText(find, document);
                String replace = entityData.getItemValueString("replace");
                replace = this.workflowService.adaptText(replace, document);
                this.replaceXWPFDocument(doc, find, replace);
            }
            logger.fine("findreplace completed");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            doc.write((OutputStream)byteArrayOutputStream);
            doc.close();
            newContent = byteArrayOutputStream.toByteArray();
        }
        if (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx")) {
            doc = new XSSFWorkbook((InputStream)imputStream);
            logger.fine("XSSFWorkbook loaded");
            XSSFSheet sheet = doc.getSheetAt(0);
            for (String entityDev : replaceDevList) {
                ItemCollection entityData = XMLParser.parseItemStructure((String)entityDev);
                if (entityData == null) continue;
                String find = entityData.getItemValueString("find");
                String replace = entityData.getItemValueString("replace");
                replace = this.workflowService.adaptText(replace, document);
                String itemname = entityData.getItemValueString("itemname");
                if (!itemname.isEmpty()) {
                    List valueList = document.getItemValue(itemname);
                    if (valueList.size() <= 0) continue;
                    this.replaceXSSFSheetItemValue((XSSFWorkbook)doc, sheet, find, valueList.get(0));
                    continue;
                }
                this.replaceXSSFSheetStringValue((XSSFWorkbook)doc, sheet, find, replace);
            }
            logger.fine("findreplace completed");
            if (eval != null && !eval.isEmpty()) {
                String[] stringArray;
                for (String cellPos : stringArray = eval.split(";")) {
                    this.evalXSSFSheet((XSSFWorkbook)doc, sheet, cellPos);
                }
                logger.fine("formula evualtion completed");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            doc.write((OutputStream)byteArrayOutputStream);
            doc.close();
            newContent = byteArrayOutputStream.toByteArray();
        }
        FileData fileDataNew = new FileData(fileData.getName(), newContent, fileData.getContentType(), null);
        document.addFileData(fileDataNew);
        logger.fine("new document added");
    }

    private void replaceXSSFSheetStringValue(XSSFWorkbook doc, XSSFSheet sheet, String find, String replace) throws PluginException {
        logger.finest("update cell " + find);
        XSSFCell cell = POIFindReplaceAdapter.getCellByRef(doc, sheet, find);
        if (cell == null) {
            logger.warning("Cell " + find + " not found.");
            return;
        }
        try {
            float f = Float.parseFloat(replace);
            cell.setCellValue((double)f);
        }
        catch (NumberFormatException e) {
            cell.setCellValue(replace);
        }
    }

    private void replaceXSSFSheetItemValue(XSSFWorkbook doc, XSSFSheet sheet, String find, Object itemValue) throws PluginException {
        logger.finest("update cell " + find);
        XSSFCell cell = POIFindReplaceAdapter.getCellByRef(doc, sheet, find);
        if (cell == null) {
            logger.warning("Cell " + find + " not found.");
            return;
        }
        if (itemValue instanceof Date) {
            cell.setCellValue((Date)itemValue);
        } else if (itemValue instanceof Double) {
            cell.setCellValue(((Double)itemValue).doubleValue());
        } else {
            cell.setCellValue(itemValue.toString());
        }
    }

    public static XSSFCell getCellByRef(XSSFWorkbook doc, XSSFSheet sheet, String cellReference) {
        CellReference cr;
        XSSFRow row;
        XSSFCell cell = null;
        XSSFName aNamedCell = doc.getName(cellReference);
        if (aNamedCell != null) {
            logger.finest("...resolving named cell = " + aNamedCell.getNameName());
            cellReference = aNamedCell.getRefersToFormula();
        }
        if ((row = sheet.getRow((cr = new CellReference(cellReference)).getRow())) == null) {
            logger.severe("Unable to resolve cell ref '" + cellReference + "'!");
            return null;
        }
        cell = row.getCell((int)cr.getCol());
        return cell;
    }

    public void evalXSSFSheet(XSSFWorkbook doc, XSSFSheet sheet, String cell) throws PluginException {
        XSSFFormulaEvaluator evaluator = doc.getCreationHelper().createFormulaEvaluator();
        XSSFCell c = POIFindReplaceAdapter.getCellByRef(doc, sheet, cell);
        if (c == null) {
            logger.warning("Cell " + cell + " not found.");
            return;
        }
        if (c.getCellType() == CellType.FORMULA) {
            logger.finest("...eval cell " + cell);
            try {
                CellType evalResult = evaluator.evaluateFormulaCell((Cell)c);
                if (evalResult == CellType.ERROR) {
                    logger.warning("...unable to evaluate cell " + cell);
                }
            }
            catch (Exception poie) {
                logger.warning("...failed to evaluate cell " + cell + " : " + poie.getMessage());
            }
        }
    }

    private void replaceXWPFDocument(XWPFDocument doc, String find, String replace) {
        for (XWPFParagraph p : doc.getParagraphs()) {
            this.replaceParagraph(p, find, replace);
        }
        for (XWPFTable t : doc.getTables()) {
            List rows = t.getRows();
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                for (XWPFTableCell cell : cells) {
                    for (XWPFParagraph p : cell.getParagraphs()) {
                        this.replaceParagraph(p, find, replace);
                    }
                }
            }
        }
    }

    void replaceParagraph(XWPFParagraph p, String find, String replace) {
        List runs = p.getRuns();
        if (runs != null) {
            for (XWPFRun r : runs) {
                String text = r.getText(0);
                if (text == null || !text.contains(find)) continue;
                text = text.replace(find, replace);
                logger.fine("..replace " + find + " with  " + replace);
                r.setText(text, 0);
            }
        }
    }

    static int cellColumnToNumber(String name) {
        name = name.toUpperCase();
        int number = 0;
        for (int i = 0; i < name.length(); ++i) {
            number = number * 26 + (name.charAt(i) - 64);
        }
        return number - 1;
    }
}

