/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.poi;

import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellCopyPolicy;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class POIUtil {
    private static Logger logger = Logger.getLogger(POIUtil.class.getName());

    public static void insertRows(XSSFSheet sheet, String cellReference, int numberOfRows) {
        if (sheet == null || numberOfRows == 0 || cellReference == null || cellReference.isEmpty()) {
            return;
        }
        CellReference refCell = new CellReference(cellReference);
        XSSFRow refRow = sheet.getRow(refCell.getRow());
        int startRow = refRow.getRowNum();
        sheet.shiftRows(startRow, sheet.getLastRowNum(), numberOfRows, true, true);
        int rowPos = startRow;
        for (int i = startRow; i < startRow + numberOfRows; ++i) {
            XSSFRow row = sheet.createRow(rowPos);
            row.copyRowFrom((Row)refRow, new CellCopyPolicy());
            ++rowPos;
        }
    }

    public static void insertColumn(XSSFSheet sheet, int startColumn, int endColumn) {
        int i;
        if (sheet == null || endColumn == 0) {
            return;
        }
        logger.fine("start Column=" + startColumn);
        int lastColumn = -1;
        for (Row row : sheet) {
            if (row.getLastCellNum() <= lastColumn) continue;
            lastColumn = row.getLastCellNum() - 1;
        }
        logger.fine("last  Column=" + lastColumn);
        if (lastColumn > 1000) {
            logger.warning("Excel Template could be corrupted! - Unexpected last lastColumn: " + lastColumn);
        }
        HashMap<Integer, Integer> columnWidths = new HashMap<Integer, Integer>();
        for (i = startColumn; i <= endColumn; ++i) {
            columnWidths.put(i, sheet.getColumnWidth(i));
            logger.fine("  column width " + i + " = " + sheet.getColumnWidth(i));
        }
        sheet.shiftColumns(startColumn, lastColumn, 1);
        for (i = startColumn + 1; i <= endColumn + 1; ++i) {
            Integer width = (Integer)columnWidths.get(i - 1);
            logger.fine("  restore width " + i + " = " + width);
            sheet.setColumnWidth(i, width.intValue());
        }
        CellCopyPolicy copyPolicy = new CellCopyPolicy.Builder().cellStyle(true).cellFormula(true).mergedRegions(false).build();
        for (Row row : sheet) {
            XSSFCell refCell;
            if (row == null || (refCell = ((XSSFRow)row).getCell(startColumn + 1)) == null) continue;
            XSSFCell newCell = ((XSSFRow)row).createCell(startColumn);
            newCell.copyCellFrom((Cell)refCell, copyPolicy);
        }
    }

    public static String getCellReference(int col, int row) {
        StringBuilder colRef = new StringBuilder();
        int temp = col;
        while (temp >= 0) {
            int remainder = temp % 26;
            colRef.insert(0, (char)(65 + remainder));
            temp = temp / 26 - 1;
        }
        return colRef.toString() + (row + 1);
    }
}

