/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.poi;

import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.imixs.archive.core.SnapshotService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.poi.XSSFUtil;
import org.imixs.workflow.util.XMLParser;

public class POIFindReplaceAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(POIFindReplaceAdapter.class.getName());
    public static final String DOCUMENT_ERROR = "DOCUMENT_ERROR";
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    @Inject
    WorkflowService workflowService;
    @Inject
    SnapshotService snapshotService;
    @Inject
    ReportService reportService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException, PluginException {
        ItemCollection poiConfig = this.workflowService.evalWorkflowResult(event, "poi-update", document, false);
        if (poiConfig == null || !poiConfig.hasItem("findreplace")) {
            throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong poi configuration");
        }
        String fileName = poiConfig.getItemValueString("filename");
        if (!((fileName = this.workflowService.adaptText(fileName, document)).toLowerCase().endsWith(".docx") || fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx"))) {
            throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "Only .docx, .xls and .xlsx files are supported!");
        }
        List replaceDevList = poiConfig.getItemValue("findreplace");
        String eval = poiConfig.getItemValueString("eval");
        if (replaceDevList.size() == 0) {
            throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong poi configuration");
        }
        logger.fine("......starting update file: " + fileName + "...");
        try {
            boolean foundFile = false;
            FileData fileData = document.getFileData(fileName);
            if (fileData != null) {
                foundFile = true;
                this.updateFileData(fileData, document, replaceDevList, eval);
            } else {
                List fileNames = document.getFileNames();
                Pattern pattern = Pattern.compile(fileName);
                for (String aFileName : fileNames) {
                    if (!pattern.matcher(aFileName).find() || (fileData = document.getFileData(aFileName)) == null) continue;
                    foundFile = true;
                    this.updateFileData(fileData, document, replaceDevList, eval);
                }
            }
            if (!foundFile) {
                throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "wrong poi configuration - no file found matching '" + fileName + "' !");
            }
        }
        catch (IOException e) {
            throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), DOCUMENT_ERROR, "document '" + fileName + "' not readable: " + e.getMessage());
        }
        return document;
    }

    public void processPOIUpdate(ItemCollection workitem, ItemCollection event, String targetName) throws PluginException {
        logger.fine("... loading poi configuration..");
        ItemCollection poiConfig = this.workflowService.evalWorkflowResult(event, "poi-update", workitem, false);
        if (poiConfig == null || !poiConfig.hasItem("findreplace")) {
            throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), CONFIG_ERROR, "missing poi configuration");
        }
        List replaceDevList = poiConfig.getItemValue("findreplace");
        String eval = poiConfig.getItemValueString("eval");
        logger.info("... update template with normal poi information..");
        try {
            this.updateFileData(workitem.getFileData(targetName), workitem, replaceDevList, eval);
        }
        catch (IOException e) {
            throw new PluginException(POIFindReplaceAdapter.class.getSimpleName(), DOCUMENT_ERROR, "document '" + targetName + "' not readable: " + e.getMessage());
        }
    }

    public void updateFileData(FileData fileData, ItemCollection document, List<String> replaceDevList, String eval) throws IOException, PluginException {
        byte[] newContent = null;
        String fileName = fileData.getName();
        if (fileData.getContent() == null || fileData.getContent().length < 3) {
            fileData = this.snapshotService.getWorkItemFile(document.getUniqueID(), fileName);
        }
        ByteArrayInputStream imputStream = new ByteArrayInputStream(fileData.getContent());
        if (fileName.toLowerCase().endsWith(".docx")) {
            XWPFDocument doc = new XWPFDocument((InputStream)imputStream);
            logger.fine("XWPFDocument loaded");
            this.updateXWPFDocument(doc, document, replaceDevList);
            logger.fine("findreplace completed");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            doc.write((OutputStream)byteArrayOutputStream);
            doc.close();
            newContent = byteArrayOutputStream.toByteArray();
        }
        if (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx")) {
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)imputStream);
            logger.fine("XSSFWorkbook loaded");
            XSSFUtil.updateXSSFWorkbook(workbook, document, replaceDevList, this.workflowService);
            logger.fine("findreplace completed");
            XSSFSheet sheet = workbook.getSheetAt(0);
            if (eval != null && !eval.isEmpty()) {
                String[] cellPositions;
                for (String cellPos : cellPositions = eval.split(";")) {
                    XSSFUtil.evalXSSFSheet(workbook, sheet, cellPos);
                }
                logger.fine("formula evualtion completed");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)byteArrayOutputStream);
            workbook.close();
            newContent = byteArrayOutputStream.toByteArray();
        }
        FileData fileDataNew = new FileData(fileData.getName(), newContent, fileData.getContentType(), null);
        document.addFileData(fileDataNew);
        logger.fine("new document added");
    }

    public void updateXWPFDocument(XWPFDocument document, ItemCollection workitem, List<String> replaceDevList) throws PluginException {
        for (String entityDev : replaceDevList) {
            ItemCollection entityData = XMLParser.parseItemStructure((String)entityDev);
            if (entityData == null) continue;
            String find = entityData.getItemValueString("find");
            find = this.workflowService.adaptText(find, workitem);
            String replace = entityData.getItemValueString("replace");
            replace = this.workflowService.adaptText(replace, workitem);
            this.replaceXWPFDocument(document, find, replace);
        }
    }

    public void replaceXWPFDocument(XWPFDocument doc, String find, String replace) {
        for (XWPFParagraph p : doc.getParagraphs()) {
            this.replaceParagraph(p, find, replace);
        }
        for (XWPFTable t : doc.getTables()) {
            List rows = t.getRows();
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                for (XWPFTableCell cell : cells) {
                    for (XWPFParagraph p : cell.getParagraphs()) {
                        this.replaceParagraph(p, find, replace);
                    }
                }
            }
        }
    }

    void replaceParagraph(XWPFParagraph p, String find, String replace) {
        List runs = p.getRuns();
        if (runs != null) {
            for (XWPFRun r : runs) {
                String text = r.getText(0);
                if (text == null || !text.contains(find)) continue;
                text = text.replace(find, replace);
                logger.fine("..replace " + find + " with  " + replace);
                r.setText(text, 0);
            }
        }
    }

    static int cellColumnToNumber(String name) {
        name = name.toUpperCase();
        int number = 0;
        for (int i = 0; i < name.length(); ++i) {
            number = number * 26 + (name.charAt(i) - 64);
        }
        return number - 1;
    }
}

