/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.poi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellCopyPolicy;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.util.XMLParser;

public class XSSFUtil {
    private static Logger logger = Logger.getLogger(XSSFUtil.class.getName());
    public static final String ERROR_CONFIG = "CONFIG_ERROR";

    public static void insertRows(XSSFSheet sheet, String cellReference, int numberOfRows) {
        if (sheet == null || numberOfRows == 0 || cellReference == null || cellReference.isEmpty()) {
            return;
        }
        CellReference refCell = new CellReference(cellReference);
        XSSFRow refRow = sheet.getRow(refCell.getRow());
        int startRow = refRow.getRowNum();
        sheet.shiftRows(startRow, sheet.getLastRowNum(), numberOfRows, true, true);
        int rowPos = startRow;
        for (int i = startRow; i < startRow + numberOfRows; ++i) {
            XSSFRow row = sheet.createRow(rowPos);
            row.copyRowFrom((Row)refRow, new CellCopyPolicy());
            ++rowPos;
        }
    }

    public static void insertColumn(XSSFSheet sheet, int startColumn, int endColumn) {
        int i;
        if (sheet == null || endColumn == 0) {
            return;
        }
        logger.fine("start Column=" + startColumn);
        int lastColumn = -1;
        for (Row row : sheet) {
            if (row.getLastCellNum() <= lastColumn) continue;
            lastColumn = row.getLastCellNum() - 1;
        }
        logger.fine("last  Column=" + lastColumn);
        if (lastColumn > 1000) {
            logger.warning("Excel Template could be corrupted! - Unexpected last lastColumn: " + lastColumn);
        }
        HashMap<Integer, Integer> columnWidths = new HashMap<Integer, Integer>();
        for (i = startColumn; i <= endColumn; ++i) {
            columnWidths.put(i, sheet.getColumnWidth(i));
            logger.fine("  column width " + i + " = " + sheet.getColumnWidth(i));
        }
        sheet.shiftColumns(startColumn, lastColumn, 1);
        for (i = startColumn + 1; i <= endColumn + 1; ++i) {
            Integer width = (Integer)columnWidths.get(i - 1);
            logger.fine("  restore width " + i + " = " + width);
            sheet.setColumnWidth(i, width.intValue());
        }
        CellCopyPolicy copyPolicy = new CellCopyPolicy.Builder().cellStyle(true).cellFormula(true).mergedRegions(false).build();
        for (Row row : sheet) {
            XSSFCell refCell;
            if (row == null || (refCell = ((XSSFRow)row).getCell(startColumn + 1)) == null) continue;
            XSSFCell newCell = ((XSSFRow)row).createCell(startColumn);
            newCell.copyCellFrom((Cell)refCell, copyPolicy);
        }
    }

    public static String getCellReference(int col, int row) {
        StringBuilder colRef = new StringBuilder();
        int temp = col;
        while (temp >= 0) {
            int remainder = temp % 26;
            colRef.insert(0, (char)(65 + remainder));
            temp = temp / 26 - 1;
        }
        return colRef.toString() + (row + 1);
    }

    public static XSSFCell getCellByRef(XSSFWorkbook doc, XSSFSheet sheet, String cellReference) {
        CellReference cr;
        XSSFRow row;
        XSSFCell cell = null;
        XSSFName aNamedCell = doc.getName(cellReference);
        if (aNamedCell != null) {
            logger.finest("...resolving named cell = " + aNamedCell.getNameName());
            cellReference = aNamedCell.getRefersToFormula();
        }
        if ((row = sheet.getRow((cr = new CellReference(cellReference)).getRow())) == null) {
            logger.severe("Unable to resolve cell ref '" + cellReference + "'!");
            return null;
        }
        cell = row.getCell((int)cr.getCol());
        return cell;
    }

    public static void updateXSSFWorkbook(XSSFWorkbook workbook, ItemCollection workitem, List<String> replaceDevList, WorkflowService workflowService) throws PluginException {
        logger.fine("XSSFWorkbook loaded");
        XSSFSheet sheet = workbook.getSheetAt(0);
        for (String entityDev : replaceDevList) {
            ItemCollection entityData = XMLParser.parseItemStructure((String)entityDev);
            if (entityData == null) continue;
            String find = entityData.getItemValueString("find");
            String replace = entityData.getItemValueString("replace");
            replace = workflowService.adaptText(replace, workitem);
            String itemname = entityData.getItemValueString("itemname");
            if (!itemname.isEmpty()) {
                List valueList = workitem.getItemValue(itemname);
                if (valueList.size() <= 0) continue;
                XSSFUtil.replaceXSSFSheetItemValue(workbook, sheet, find, valueList.get(0));
                continue;
            }
            XSSFUtil.replaceXSSFSheetStringValue(workbook, sheet, find, replace);
        }
    }

    public static void replaceXSSFSheetItemValue(XSSFWorkbook doc, XSSFSheet sheet, String find, Object itemValue) throws PluginException {
        logger.finest("update cell " + find);
        XSSFCell cell = XSSFUtil.getCellByRef(doc, sheet, find);
        if (cell == null) {
            logger.warning("Cell " + find + " not found.");
            return;
        }
        if (itemValue instanceof Date) {
            cell.setCellValue((Date)itemValue);
        } else if (itemValue instanceof Double) {
            cell.setCellValue(((Double)itemValue).doubleValue());
        } else {
            cell.setCellValue(itemValue.toString());
        }
    }

    private static void replaceXSSFSheetStringValue(XSSFWorkbook doc, XSSFSheet sheet, String find, String replace) throws PluginException {
        logger.finest("update cell " + find);
        XSSFCell cell = XSSFUtil.getCellByRef(doc, sheet, find);
        if (cell == null) {
            logger.warning("Cell " + find + " not found.");
            return;
        }
        try {
            float f = Float.parseFloat(replace);
            cell.setCellValue((double)f);
        }
        catch (NumberFormatException e) {
            cell.setCellValue(replace);
        }
    }

    public static void evalXSSFSheet(XSSFWorkbook doc, XSSFSheet sheet, String cell) throws PluginException {
        XSSFFormulaEvaluator evaluator = doc.getCreationHelper().createFormulaEvaluator();
        XSSFCell c = XSSFUtil.getCellByRef(doc, sheet, cell);
        if (c == null) {
            logger.warning("Cell " + cell + " not found.");
            return;
        }
        if (c.getCellType() == CellType.FORMULA) {
            logger.finest("...eval cell " + cell);
            try {
                CellType evalResult = evaluator.evaluateFormulaCell((Cell)c);
                if (evalResult == CellType.ERROR) {
                    logger.warning("...unable to evaluate cell " + cell);
                }
            }
            catch (Exception poie) {
                logger.warning("...failed to evaluate cell " + cell + " : " + poie.getMessage());
            }
        }
    }

    public static void poiUpdate(ItemCollection dataDefinition, FileData fileData, ItemCollection poiConfig, WorkflowService workflowService) throws PluginException {
        dataDefinition.setItemValue("$modified", (Object)new Date());
        if (poiConfig == null || !poiConfig.hasItem("findreplace")) {
            return;
        }
        List replaceDevList = poiConfig.getItemValue("findreplace");
        String eval = poiConfig.getItemValueString("eval");
        try (ByteArrayInputStream imputStream = new ByteArrayInputStream(fileData.getContent());){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)imputStream);
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFUtil.updateXSSFWorkbook(workbook, dataDefinition, replaceDevList, workflowService);
            if (eval != null && !eval.isEmpty()) {
                String[] cellPositions;
                for (String cellPos : cellPositions = eval.split(";")) {
                    XSSFUtil.evalXSSFSheet(workbook, sheet, cellPos);
                }
                logger.fine("formula evaluation completed");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)byteArrayOutputStream);
            workbook.close();
            byte[] newContent = byteArrayOutputStream.toByteArray();
            fileData.setContent(newContent);
        }
        catch (IOException e) {
            throw new PluginException(XSSFUtil.class.getSimpleName(), ERROR_CONFIG, "failed to update excel export: " + e.getMessage());
        }
    }

    public static void insertDataRows(List<ItemCollection> dataset, String referenceCell, List<ItemCollection> viewItemDefinitions, FileData fileData) throws PluginException {
        try (ByteArrayInputStream imputStream = new ByteArrayInputStream(fileData.getContent());){
            int referenceRowPos;
            XSSFWorkbook doc = new XSSFWorkbook((InputStream)imputStream);
            XSSFSheet sheet = doc.getSheetAt(0);
            CellReference cr = new CellReference(referenceCell);
            XSSFRow referenceRow = sheet.getRow(cr.getRow());
            int rowPos = referenceRowPos = referenceRow.getRowNum() + 1;
            int lastRow = 999;
            logger.finest("Last rownum=" + lastRow);
            sheet.shiftRows(rowPos, lastRow, dataset.size(), true, true);
            for (ItemCollection workitem : dataset) {
                logger.finest("......copy row...");
                XSSFRow row = sheet.createRow(rowPos);
                row.copyRowFrom((Row)referenceRow, new CellCopyPolicy());
                int cellNum = 0;
                for (ItemCollection itemDef : viewItemDefinitions) {
                    String type = itemDef.getItemValueString("item.type");
                    String name = itemDef.getItemValueString("item.name");
                    switch (type) {
                        case "xs:double": {
                            row.getCell(cellNum).setCellValue(workitem.getItemValueDouble(name));
                            break;
                        }
                        case "xs:float": {
                            row.getCell(cellNum).setCellValue((double)workitem.getItemValueFloat(name));
                            break;
                        }
                        case "xs:int": {
                            row.getCell(cellNum).setCellValue((double)workitem.getItemValueInteger(name));
                            break;
                        }
                        case "xs:date": {
                            row.getCell(cellNum).setCellValue(workitem.getItemValueDate(name));
                            break;
                        }
                        default: {
                            row.getCell(cellNum).setCellValue(workitem.getItemValueString(name));
                        }
                    }
                    ++cellNum;
                }
                ++rowPos;
            }
            sheet.shiftRows(referenceRowPos, lastRow + dataset.size(), -1, true, true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            doc.write((OutputStream)byteArrayOutputStream);
            doc.close();
            byte[] newContent = byteArrayOutputStream.toByteArray();
            fileData.setContent(newContent);
        }
        catch (IOException e) {
            throw new PluginException(XSSFUtil.class.getSimpleName(), ERROR_CONFIG, "failed to update excel export: " + e.getMessage());
        }
    }
}

