/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.adapter.prometheus;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.event.Observes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.imixs.workflow.engine.DocumentEvent;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.exceptions.AccessDeniedException;

@Singleton
@Startup
@Path(value="metrics")
public class MetricService {
    private ConcurrentHashMap<String, AtomicLong> metricTotalProcessing = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> metricTotalDocuments = new ConcurrentHashMap();
    private static Logger logger = Logger.getLogger(MetricService.class.getName());

    @PostConstruct
    public void init() {
        this.metricTotalProcessing = new ConcurrentHashMap();
        this.metricTotalDocuments = new ConcurrentHashMap();
    }

    @GET
    @Produces(value={"text/plain; version=0.0.4"})
    public Response getMetrics() {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
                writer.write("# HELP documents_total The total number of accessed documents.\n");
                writer.write("# TYPE documents_total counter\n");
                for (Map.Entry metric : MetricService.this.metricTotalDocuments.entrySet()) {
                    writer.write((String)metric.getKey() + " " + ((AtomicLong)metric.getValue()).get() + "\n");
                }
                writer.write("# HELP workitems_processed_total The total number of workitems processeds.\n");
                writer.write("# TYPE workitems_processed_total counter\n");
                for (Map.Entry metric : MetricService.this.metricTotalProcessing.entrySet()) {
                    writer.write((String)metric.getKey() + " " + ((AtomicLong)metric.getValue()).get() + "\n");
                }
                ((Writer)writer).flush();
            }
        };
        return Response.ok((Object)stream).build();
    }

    public void onProcessingEvent(@Observes ProcessingEvent processingEvent) throws AccessDeniedException {
        if (processingEvent == null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (2 == processingEvent.getEventType()) {
            String metric = MetricService.buildProcessingMetric(processingEvent);
            AtomicLong counter = this.metricTotalProcessing.get(metric);
            if (counter == null) {
                counter = new AtomicLong();
            }
            counter.incrementAndGet();
            this.metricTotalProcessing.put(metric, counter);
            logger.fine("...metric " + metric + " collected in " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    public void onDocumentEvent(@Observes DocumentEvent documentEvent) throws AccessDeniedException {
        if (documentEvent == null) {
            return;
        }
        long l = System.currentTimeMillis();
        String metric = MetricService.buildDocumentMetric(documentEvent);
        if (metric == null) {
            return;
        }
        AtomicLong counter = this.metricTotalDocuments.get(metric);
        if (counter == null) {
            counter = new AtomicLong();
        }
        counter.incrementAndGet();
        this.metricTotalDocuments.put(metric, counter);
        logger.fine("...metric " + metric + " collected in " + (System.currentTimeMillis() - l) + "ms");
    }

    private static String buildDocumentMetric(DocumentEvent event) {
        if (1 == event.getEventType()) {
            return "documents_total{method=\"save\"}";
        }
        if (2 == event.getEventType()) {
            return "documents_total{method=\"load\"}";
        }
        if (3 == event.getEventType()) {
            return "documents_total{method=\"delete\"}";
        }
        return null;
    }

    private static String buildProcessingMetric(ProcessingEvent event) {
        String metric = "workitems_processed_total";
        metric = metric + "{";
        metric = metric + "type=\"" + event.getDocument().getType() + "\",";
        metric = metric + "modelversion=\"" + event.getDocument().getModelVersion() + "\",";
        metric = metric + "task=\"" + event.getDocument().getTaskID() + "\",";
        metric = metric + "event=\"" + event.getDocument().getItemValueInteger("$lastevent") + "\",";
        metric = metric + "workflowgroup=\"" + event.getDocument().getItemValueString("$workflowgroup") + "\",";
        metric = metric + "workflowstatus=\"" + event.getDocument().getItemValueString("$workflowstatus") + "\"";
        metric = metric + "} ";
        return metric;
    }
}

