/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.controller;

import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import org.imixs.workflow.engine.scheduler.SchedulerController;
import org.imixs.workflow.engine.scheduler.SchedulerService;
import org.imixs.workflow.sepa.services.SepaScheduler;

@Named
@RequestScoped
public class SepaController
extends SchedulerController {
    public static final String SEPA_CONFIGURATION = "SEPA_CONFIGURATION";
    public static final String IBAN_PATTERN = "^$|(^[A-Z]{2}(?:[ ]?[A-Z0-9]){13,32}$)";
    public static final String BIC_PATTERN = "^$|(^([a-zA-Z]{4}[a-zA-Z]{2}[a-zA-Z0-9]{2}([a-zA-Z0-9]{3})?))";
    private static final long serialVersionUID = 1L;
    @EJB
    SchedulerService schedulerService;
    private static Logger logger = Logger.getLogger(SepaController.class.getName());

    public String getName() {
        return SEPA_CONFIGURATION;
    }

    public String getSchedulerClass() {
        return SepaScheduler.class.getName();
    }

    @Valid
    @Pattern(regexp="^$|(^([a-zA-Z]{4}[a-zA-Z]{2}[a-zA-Z0-9]{2}([a-zA-Z0-9]{3})?))")
    public String getCdtrBic() {
        return this.getConfiguration().getItemValueString("_cdtr_bic");
    }

    public void setCdtrBic(String bic) {
        logger.finest("......validate _cdtr_bic...");
        this.getConfiguration().setItemValue("_cdtr_bic", (Object)bic);
    }

    @Valid
    @Pattern(regexp="^$|(^[A-Z]{2}(?:[ ]?[A-Z0-9]){13,32}$)")
    public String getCdtrIban() {
        logger.finest("......validate _cdtr_iban...");
        return this.getConfiguration().getItemValueString("_cdtr_iban");
    }

    public void setCdtrIban(String iban) {
        this.getConfiguration().setItemValue("_cdtr_iban", (Object)iban);
    }

    @Valid
    @Pattern(regexp="^$|(^([a-zA-Z]{4}[a-zA-Z]{2}[a-zA-Z0-9]{2}([a-zA-Z0-9]{3})?))")
    public String getDbtrBic() {
        return this.getConfiguration().getItemValueString("_dbtr_bic");
    }

    public void setDbtrBic(String bic) {
        logger.finest("......validate _dbtr_bic...");
        this.getConfiguration().setItemValue("_dbtr_bic", (Object)bic);
    }

    @Valid
    @Pattern(regexp="^$|(^[A-Z]{2}(?:[ ]?[A-Z0-9]){13,32}$)")
    public String getDbtrIban() {
        logger.finest("......validate _dbtr_iban...");
        return this.getConfiguration().getItemValueString("_dbtr_iban");
    }

    public void setDbtrIban(String iban) {
        this.getConfiguration().setItemValue("_dbtr_iban", (Object)iban);
    }
}

