/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.services;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.scheduler.Scheduler;
import org.imixs.workflow.engine.scheduler.SchedulerException;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.sepa.services.SepaWorkflowService;

public class SepaScheduler
implements Scheduler {
    public static final int MAX_COUNT = 999;
    @EJB
    DocumentService documentService;
    @EJB
    WorkflowService workflowService;
    @EJB
    SepaWorkflowService sepaWorkflowService;
    @EJB
    ModelService modelService;
    @EJB
    ReportService reportService;
    private static Logger logger = Logger.getLogger(SepaScheduler.class.getName());

    public ItemCollection run(ItemCollection configuration) throws SchedulerException {
        String reportName = "";
        ItemCollection sepaExport = null;
        int maxCount = configuration.getItemValueInteger("_maxcount");
        if (maxCount == 0) {
            maxCount = -1;
        }
        try {
            String modelVersion = configuration.getItemValueString("_model_version");
            int taskID = configuration.getItemValueInteger("_initial_task");
            Model model = this.modelService.getModel(modelVersion);
            ItemCollection event = model.getEvent(taskID, 100);
            ItemCollection task = model.getTask(taskID);
            ItemCollection report = this.reportService.findReport(event.getItemValueString("txtReportName"));
            if (report == null) {
                throw new SchedulerException("REPORT_ERROR", "unable to load report '" + reportName + "'. Please check  model configuration");
            }
            List masterDataSet = this.reportService.getDataSource(report, 999, 0, "$created", false, null);
            this.sepaWorkflowService.logMessage("...SEPA export started....", configuration, null);
            this.sepaWorkflowService.logMessage("...found " + masterDataSet.size() + " invoices...", configuration, null);
            if (masterDataSet.size() > 0) {
                for (ItemCollection invoice : masterDataSet) {
                    if (invoice.getItemValueString("_dbtr_iban").isEmpty()) {
                        invoice.setItemValue("_dbtr_iban", (Object)configuration.getItemValue("_dbtr_iban"));
                    }
                    if (!invoice.getItemValueString("_dbtr_bic").isEmpty()) continue;
                    invoice.setItemValue("_dbtr_bic", (Object)configuration.getItemValue("_dbtr_bic"));
                }
                Map<String, List<ItemCollection>> invoiceGroups = this.groupInvoicesBy(masterDataSet, "_dbtr_iban");
                for (String key : invoiceGroups.keySet()) {
                    List<ItemCollection> data = invoiceGroups.get(key);
                    int groupCount = data.size();
                    sepaExport = new ItemCollection().model(modelVersion).task(taskID);
                    sepaExport.replaceItemValue("$created", (Object)new Date());
                    sepaExport.replaceItemValue("$modified", (Object)new Date());
                    sepaExport.setItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
                    sepaExport.setItemValue("_dbtr_iban", (Object)key);
                    ItemCollection firstInvoice = data.get(0);
                    if (firstInvoice.hasItem("_dbtr_name")) {
                        sepaExport.setItemValue("_dbtr_name", (Object)firstInvoice.getItemValue("_dbtr_name"));
                    }
                    if (firstInvoice.hasItem("_dbtr_bic")) {
                        sepaExport.setItemValue("_dbtr_bic", (Object)firstInvoice.getItemValue("_dbtr_bic"));
                    }
                    String modelTaskGroupName = task.getItemValueString("txtworkflowgroup");
                    sepaExport.setItemValue("$workflowgroup", (Object)modelTaskGroupName);
                    this.sepaWorkflowService.logMessage("...starting SEPA export for iban=" + key + "...", configuration, sepaExport);
                    for (ItemCollection invoice : data) {
                        sepaExport.appendItemValue("txtworkitemref", (Object)invoice.getUniqueID());
                        invoice = this.harmonizeItem(invoice, "_cdtr_name");
                        invoice = this.harmonizeItem(invoice, "_dbtr_name");
                        this.sepaWorkflowService.logMessage("......Invoice: " + invoice.getUniqueID() + " added. ", configuration, sepaExport);
                    }
                    data.add(sepaExport);
                    String sDepName = sepaExport.getItemValueString("_dbtr_name");
                    sDepName = sDepName.replace("&", "_");
                    sDepName = sDepName.replace(">", "_");
                    sDepName = sDepName.replace("<", "_");
                    sDepName = sDepName.replace(" ", "_");
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HHmm");
                    String sepaFileName = "sepa_" + sDepName + "_" + df.format(new Date()) + ".xml";
                    FileData filedata = this.reportService.transformDataSource(report, data, sepaFileName);
                    sepaExport.addFileData(filedata);
                    this.sepaWorkflowService.processInvoices(sepaExport, data, event, configuration);
                    this.sepaWorkflowService.logMessage("...SEPA export " + key + "  finished.", configuration, sepaExport);
                    this.sepaWorkflowService.logMessage("..." + groupCount + " invoices exported. ", configuration, sepaExport);
                    sepaExport.event(100).event(200);
                    this.workflowService.processWorkItem(sepaExport);
                }
            } else {
                logger.finest("......no invoices found.");
                return configuration;
            }
            this.sepaWorkflowService.logMessage("...SEPA export completed", configuration, null);
        }
        catch (PluginException e) {
            try {
                if (sepaExport != null) {
                    this.sepaWorkflowService.logMessage("Failed: " + e.getMessage(), configuration, sepaExport);
                    sepaExport.event(300);
                    this.workflowService.processWorkItem(sepaExport);
                }
            }
            catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e1) {
                throw new SchedulerException("REPORT_ERROR", "Failed to execute sepa report '" + reportName + "' : " + e.getMessage(), (Exception)((Object)e));
            }
        }
        catch (IOException | JAXBException | TransformerException | AccessDeniedException | ModelException | ProcessingErrorException | QueryException e) {
            try {
                if (sepaExport != null) {
                    this.sepaWorkflowService.logMessage("Failed: " + e.getMessage(), configuration, sepaExport);
                    sepaExport.event(300);
                    this.workflowService.processWorkItem(sepaExport);
                }
            }
            catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e1) {
                throw new SchedulerException("REPORT_ERROR", "Failed to execute sepa report '" + reportName + "' : " + e.getMessage(), (Exception)e);
            }
            throw new SchedulerException("REPORT_ERROR", "Failed to execute sepa report '" + reportName + "' : " + e.getMessage(), (Exception)e);
        }
        return configuration;
    }

    private Map<String, List<ItemCollection>> groupInvoicesBy(List<ItemCollection> datasource, String keyItem) {
        HashMap<String, List<ItemCollection>> result = new HashMap<String, List<ItemCollection>>();
        logger.info("......grouping invoices by '" + keyItem + "'");
        for (ItemCollection invoice : datasource) {
            String key = invoice.getItemValueString(keyItem);
            logger.info("......building invoice group for '" + key + "'");
            ArrayList<ItemCollection> group = (ArrayList<ItemCollection>)result.get(key);
            if (group == null) {
                group = new ArrayList<ItemCollection>();
            }
            group.add(invoice);
            result.put(key, group);
        }
        return result;
    }

    private ItemCollection harmonizeItem(ItemCollection invoice, String itemName) {
        String value = null;
        value = invoice.getItemValueString(itemName);
        value = value.replace("&", " ");
        value = value.replace(">", " ");
        value = value.replace("<", " ");
        invoice.replaceItemValue(itemName, (Object)value);
        return invoice;
    }
}

