/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.services;

import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.util.XMLParser;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class SepaWorkflowService {
    public static final String SEPA_CONFIGURATION = "SEPA_CONFIGURATION";
    public static final int EVENT_START = 100;
    public static final int EVENT_SUCCESS = 200;
    public static final int EVENT_FAILED = 300;
    public static final String INVOICE_UPDATE = "invoice_update";
    public static final String LINK_PROPERTY = "txtworkitemref";
    public static final String ITEM_MODEL_VERSION = "_model_version";
    public static final String ITEM_INITIAL_TASK = "_initial_task";
    public static final String ITEM_DBTR_IBAN = "_dbtr_iban";
    public static final String ITEM_DBTR_BIC = "_dbtr_bic";
    public static final String ITEM_DBTR_NAME = "_dbtr_name";
    public static final String ITEM_CDTR_IBAN = "_cdtr_iban";
    public static final String ITEM_CDTR_BIC = "_cdtr_bic";
    public static final String ITEM_CDTR_NAME = "_cdtr_name";
    public static final String REPORT_ERROR = "REPORT_ERROR";
    @EJB
    WorkflowService workflowService = null;
    private static Logger logger = Logger.getLogger(SepaWorkflowService.class.getName());

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void processInvoices(ItemCollection sepaExport, List<ItemCollection> invoices, ItemCollection event, ItemCollection configuration) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        List subProcessDefinitions = null;
        ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, sepaExport, false);
        subProcessDefinitions = evalItemCollection.getItemValue(INVOICE_UPDATE);
        if (subProcessDefinitions == null || subProcessDefinitions.size() == 0) {
            return;
        }
        for (String processValue : subProcessDefinitions) {
            ItemCollection processData;
            if (processValue.trim().isEmpty() || (processData = XMLParser.parseItemStructure((String)processValue)) == null) continue;
            String model_pattern = processData.getItemValueString("modelversion");
            String process_pattern = processData.getItemValueString("task");
            for (ItemCollection _invoice : invoices) {
                ItemCollection invoice = this.workflowService.getWorkItem(_invoice.getUniqueID());
                if (invoice == null) continue;
                String subModelVersion = invoice.getModelVersion();
                String subProcessID = "" + invoice.getTaskID();
                if (!Pattern.compile(model_pattern).matcher(subModelVersion).find() || !Pattern.compile(process_pattern).matcher(subProcessID).find()) continue;
                logger.finest("...... subprocess matches criteria.");
                if (processData.hasItem("items")) {
                    logger.warning("subprocess itemList is not supported by the SepaScheduler!");
                }
                try {
                    invoice.setEventID(Integer.valueOf(processData.getItemValueString("event")).intValue());
                }
                catch (NumberFormatException e) {
                    throw new ModelException("INVALID_MODEL_ENTRY", "unable to parse event '" + processData.getItemValueString("event") + "'. Please check your model definition '" + invoice.getModelVersion() + "'!", (Exception)e);
                }
                invoice = this.workflowService.processWorkItem(invoice);
                this.logMessage("...invoice " + _invoice.getUniqueID() + " processed.", configuration, null);
            }
        }
    }

    public void logMessage(String message, ItemCollection configuration, ItemCollection workitem) {
        if (configuration != null) {
            configuration.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        if (workitem != null) {
            workitem.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        logger.info(message);
    }
}

