/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.scheduler.SchedulerController;
import org.imixs.workflow.engine.scheduler.SchedulerService;
import org.imixs.workflow.sepa.services.SepaScheduler;

@Named
@ViewScoped
public class SepaController
extends SchedulerController {
    public static final String SEPA_CONFIGURATION = "SEPA_CONFIGURATION";
    private static final long serialVersionUID = 1L;
    protected List<ItemCollection> dbtrList = null;
    @EJB
    SchedulerService schedulerService;
    @EJB
    DocumentService documentService;
    private static Logger logger = Logger.getLogger(SepaController.class.getName());

    @PostConstruct
    public void init() {
        super.init();
        this.loadDbtrListFromConfiguration();
    }

    public String getName() {
        return SEPA_CONFIGURATION;
    }

    public String getSchedulerClass() {
        return SepaScheduler.class.getName();
    }

    public double calculateSum(List<String> refids, String item) {
        double result = 0.0;
        for (String id : refids) {
            ItemCollection doc = this.documentService.load(id);
            if (doc != null) {
                result += doc.getItemValueDouble(item);
                continue;
            }
            logger.warning("invalid read access to calculate sepa sum");
        }
        return (double)Math.round(result * 100.0) / 100.0;
    }

    public void loadDbtrListFromConfiguration() {
        this.dbtrList = new ArrayList<ItemCollection>();
        List mapItems = this.getConfiguration().getItemValue("dbtr.config");
        for (Object mapOderItem : mapItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            this.dbtrList.add(itemCol);
        }
        if (this.dbtrList.size() == 0 && this.getConfiguration().hasItem("_dbtr_name")) {
            logger.info("...migrate deprecated sepa configuration..");
            ItemCollection dbtr = new ItemCollection();
            dbtr.setItemValue("dbtr.name", (Object)this.getConfiguration().getItemValue("_dbtr_name"));
            dbtr.setItemValue("dbtr.iban", (Object)this.getConfiguration().getItemValue("_dbtr_iban"));
            dbtr.setItemValue("dbtr.bic", (Object)this.getConfiguration().getItemValue("_dbtr_bic"));
            dbtr.setItemValue("name", (Object)"SEPA");
            this.dbtrList.add(dbtr);
            this.getConfiguration().removeItem("_dbtr_name");
            this.getConfiguration().removeItem("_dbtr_iban");
            this.getConfiguration().removeItem("_dbtr_bic");
        }
    }

    public void saveConfiguration() {
        ItemCollection config = this.getConfiguration();
        ArrayList<Map> mapItemList = new ArrayList<Map>();
        if (this.dbtrList != null) {
            logger.fine("Convert option items into Map...");
            for (ItemCollection dbtrItem : this.dbtrList) {
                mapItemList.add(dbtrItem.getAllItems());
            }
            config.replaceItemValue("dbtr.config", mapItemList);
        }
        super.saveConfiguration();
    }

    public List<ItemCollection> getDbtrList() {
        return this.dbtrList;
    }

    public void addDbtr() {
        if (this.dbtrList == null) {
            this.dbtrList = new ArrayList<ItemCollection>();
        }
        ItemCollection source = new ItemCollection();
        this.dbtrList.add(source);
    }

    public void removeDbtr(String name) {
        if (name != null && this.dbtrList != null) {
            for (ItemCollection dbtr : this.dbtrList) {
                if (!name.equals(dbtr.getItemValueString("name"))) continue;
                this.dbtrList.remove(dbtr);
                break;
            }
        }
    }
}

