/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.services;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.inject.Inject;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.scheduler.Scheduler;
import org.imixs.workflow.engine.scheduler.SchedulerException;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.sepa.services.SepaWorkflowService;

public class SepaScheduler
implements Scheduler {
    @EJB
    DocumentService documentService;
    @EJB
    WorkflowService workflowService;
    @EJB
    SepaWorkflowService sepaWorkflowService;
    @EJB
    ModelService modelService;
    @EJB
    ReportService reportService;
    @Inject
    @ConfigProperty(name="sepa.invoices.maxcount", defaultValue="100")
    int invoicesMaxCount;
    private static Logger logger = Logger.getLogger(SepaScheduler.class.getName());

    public ItemCollection run(ItemCollection configuration) throws SchedulerException {
        String reportName = "";
        ItemCollection sepaExport = null;
        try {
            String modelVersion = configuration.getItemValueString("_model_version");
            int taskID = configuration.getItemValueInteger("_initial_task");
            Model model = this.modelService.getModel(modelVersion);
            ItemCollection event = model.getEvent(taskID, 100);
            ItemCollection task = model.getTask(taskID);
            ItemCollection report = this.reportService.findReport(event.getItemValueString("txtReportName"));
            if (report == null) {
                throw new SchedulerException("REPORT_ERROR", "Missing report definition. Unable to load report '" + reportName + "'. Please check  model configuration " + taskID + "." + 100);
            }
            List masterDataSet = this.reportService.getDataSource(report, this.invoicesMaxCount, 0, "$created", false, null);
            this.sepaWorkflowService.logMessage("...SEPA export started....", configuration, null);
            this.sepaWorkflowService.logMessage("...found " + masterDataSet.size() + " new invoices...", configuration, null);
            if (masterDataSet.size() > 0) {
                for (ItemCollection invoice : masterDataSet) {
                    if (!invoice.getItemValueString("dbtr.iban").isEmpty()) continue;
                    String paymentType = invoice.getItemValueString("payment.type");
                    ItemCollection dbtrOption = this.sepaWorkflowService.findDbtrOptionByPaymentType(paymentType, configuration);
                    if (dbtrOption != null) {
                        invoice.setItemValue("dbtr.iban", (Object)dbtrOption.getItemValue("dbtr.iban"));
                        invoice.setItemValue("dbtr.bic", (Object)dbtrOption.getItemValue("dbtr.bic"));
                        invoice.setItemValue("dbtr.name", (Object)dbtrOption.getItemValue("dbtr.name"));
                        invoice.setItemValue("sepa.report", (Object)dbtrOption.getItemValue("sepa.report"));
                        continue;
                    }
                    this.sepaWorkflowService.logMessage("...Warning: payment.type '" + paymentType + "' not found in SEPA configuration", configuration, null);
                }
                Map<String, List<ItemCollection>> invoiceGroups = this.groupInvoicesBy(masterDataSet, "dbtr.iban");
                for (String key : invoiceGroups.keySet()) {
                    List<ItemCollection> data = invoiceGroups.get(key);
                    int groupCount = data.size();
                    sepaExport = new ItemCollection().model(modelVersion).task(taskID);
                    sepaExport.replaceItemValue("$created", (Object)new Date());
                    sepaExport.replaceItemValue("$modified", (Object)new Date());
                    sepaExport.setItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
                    sepaExport.setItemValue("dbtr.iban", (Object)key);
                    ItemCollection firstInvoice = data.get(0);
                    if (firstInvoice.hasItem("dbtr.name")) {
                        sepaExport.setItemValue("dbtr.name", (Object)firstInvoice.getItemValue("dbtr.name"));
                    }
                    if (firstInvoice.hasItem("dbtr.bic")) {
                        sepaExport.setItemValue("dbtr.bic", (Object)firstInvoice.getItemValue("dbtr.bic"));
                    }
                    if (firstInvoice.hasItem("payment.type")) {
                        sepaExport.setItemValue("payment.type", (Object)firstInvoice.getItemValue("payment.type"));
                    }
                    if (firstInvoice.hasItem("sepa.report")) {
                        sepaExport.setItemValue("sepa.report", (Object)firstInvoice.getItemValue("sepa.report"));
                    }
                    String modelTaskGroupName = task.getItemValueString("txtworkflowgroup");
                    sepaExport.setItemValue("$workflowgroup", (Object)modelTaskGroupName);
                    this.sepaWorkflowService.logMessage("...starting SEPA export for iban=" + key + "...", configuration, sepaExport);
                    for (ItemCollection invoice : data) {
                        sepaExport.appendItemValue("$workitemref", (Object)invoice.getUniqueID());
                        sepaExport.appendItemValue("txtworkitemref", (Object)invoice.getUniqueID());
                        invoice = this.harmonizeItem(invoice, "cdtr.name");
                        invoice = this.harmonizeItem(invoice, "dbtr.name");
                        logger.finest("......Invoice: " + invoice.getUniqueID() + " added. ");
                    }
                    data.add(sepaExport);
                    String sDepName = sepaExport.getItemValueString("dbtr.name");
                    sDepName = sDepName.replace("&", "_");
                    sDepName = sDepName.replace(">", "_");
                    sDepName = sDepName.replace("<", "_");
                    sDepName = sDepName.replace(" ", "_");
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HHmm");
                    String sepaFileName = "sepa_" + sDepName + "_" + df.format(new Date()) + ".xml";
                    FileData filedata = null;
                    String optionalSepaReport = sepaExport.getItemValueString("sepa.report");
                    ItemCollection reportOptional = this.reportService.findReport(optionalSepaReport);
                    if (reportOptional != null) {
                        filedata = this.reportService.transformDataSource(reportOptional, data, sepaFileName);
                        this.sepaWorkflowService.logMessage("...SEPA export report=" + sepaExport.getItemValueString("sepa.report"), configuration, sepaExport);
                    } else {
                        if (!optionalSepaReport.isEmpty()) {
                            this.sepaWorkflowService.logMessage("...WARNING - SEPA export report " + optionalSepaReport + " not found! Default report will be used.", configuration, sepaExport);
                        }
                        filedata = this.reportService.transformDataSource(report, data, sepaFileName);
                    }
                    sepaExport.addFileData(filedata);
                    this.sepaWorkflowService.processInvoices(sepaExport, data, event, configuration);
                    this.sepaWorkflowService.logMessage("...SEPA export " + key + "  finished.", configuration, sepaExport);
                    this.sepaWorkflowService.logMessage("..." + groupCount + " invoices exported. ", configuration, sepaExport);
                    sepaExport.event(100).event(200);
                    this.workflowService.processWorkItem(sepaExport);
                }
            } else {
                logger.finest("......no invoices found.");
                return configuration;
            }
            this.sepaWorkflowService.logMessage("...SEPA export completed", configuration, null);
        }
        catch (PluginException e) {
            try {
                if (sepaExport != null) {
                    this.sepaWorkflowService.logMessage("Failed: " + e.getMessage(), configuration, sepaExport);
                    sepaExport.event(300);
                    this.workflowService.processWorkItem(sepaExport);
                }
            }
            catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e1) {
                throw new SchedulerException("REPORT_ERROR", "Failed to execute sepa report '" + reportName + "' : " + e.getMessage(), (Exception)((Object)e));
            }
        }
        catch (IOException | JAXBException | TransformerException | AccessDeniedException | ModelException | ProcessingErrorException | QueryException e) {
            try {
                if (sepaExport != null) {
                    this.sepaWorkflowService.logMessage("Failed: " + e.getMessage(), configuration, sepaExport);
                    sepaExport.event(300);
                    this.workflowService.processWorkItem(sepaExport);
                }
            }
            catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e1) {
                throw new SchedulerException("REPORT_ERROR", "Failed to execute sepa report '" + reportName + "' : " + e.getMessage(), (Exception)e);
            }
            throw new SchedulerException("REPORT_ERROR", "Failed to execute sepa report '" + reportName + "' : " + e.getMessage(), (Exception)e);
        }
        catch (RuntimeException re) {
            logger.severe("...SEPA Runtime Error");
            this.sepaWorkflowService.logMessage("!!ERROR!! Failed to run SEPA scheduler: " + re.getMessage(), configuration, null);
        }
        return configuration;
    }

    private Map<String, List<ItemCollection>> groupInvoicesBy(List<ItemCollection> datasource, String keyItem) {
        HashMap<String, List<ItemCollection>> result = new HashMap<String, List<ItemCollection>>();
        logger.info("......grouping invoices by '" + keyItem + "'");
        for (ItemCollection invoice : datasource) {
            String key = invoice.getItemValueString(keyItem);
            logger.info("......building invoice group for '" + key + "'");
            ArrayList<ItemCollection> group = (ArrayList<ItemCollection>)result.get(key);
            if (group == null) {
                group = new ArrayList<ItemCollection>();
            }
            group.add(invoice);
            result.put(key, group);
        }
        return result;
    }

    private ItemCollection harmonizeItem(ItemCollection invoice, String itemName) {
        String value = null;
        value = invoice.getItemValueString(itemName);
        value = value.replace("&", " ");
        value = value.replace(">", " ");
        value = value.replace("<", " ");
        invoice.replaceItemValue(itemName, (Object)value);
        return invoice;
    }
}

