/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.util.XMLParser;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class SepaWorkflowService {
    public static final String SEPA_CONFIGURATION = "SEPA_CONFIGURATION";
    public static final int EVENT_START = 100;
    public static final int EVENT_SUCCESS = 200;
    public static final int EVENT_FAILED = 300;
    public static final String INVOICE_UPDATE = "invoice_update";
    public static final String LINK_PROPERTY = "$workitemref";
    public static final String ITEM_MODEL_VERSION = "_model_version";
    public static final String ITEM_INITIAL_TASK = "_initial_task";
    public static final String ITEM_PAYMENT_TYPE = "payment.type";
    public static final String ITEM_SEPA_REPORT = "sepa.report";
    public static final String ITEM_DBTR_IBAN = "dbtr.iban";
    public static final String ITEM_DBTR_BIC = "dbtr.bic";
    public static final String ITEM_DBTR_NAME = "dbtr.name";
    public static final String ITEM_CDTR_IBAN = "cdtr.iban";
    public static final String ITEM_CDTR_BIC = "cdtr.bic";
    public static final String ITEM_CDTR_NAME = "cdtr.name";
    public static final String ITEM_DBTR_CONFIG = "dbtr.config";
    public static final String REPORT_ERROR = "REPORT_ERROR";
    @EJB
    WorkflowService workflowService = null;
    private static Logger logger = Logger.getLogger(SepaWorkflowService.class.getName());

    public void processInvoices(ItemCollection sepaExport, List<ItemCollection> invoices, ItemCollection event, ItemCollection configuration) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        List subProcessDefinitions = null;
        ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, "sepa", sepaExport, false);
        if (evalItemCollection == null) {
            logger.warning("...expected sepa item in workflow result is missing - data will not be processed!");
            return;
        }
        subProcessDefinitions = evalItemCollection.getItemValue(INVOICE_UPDATE);
        if (subProcessDefinitions == null || subProcessDefinitions.size() == 0) {
            return;
        }
        for (String processValue : subProcessDefinitions) {
            ItemCollection processData;
            if (processValue.trim().isEmpty() || (processData = XMLParser.parseItemStructure((String)processValue)) == null) continue;
            String model_pattern = processData.getItemValueString("modelversion");
            String process_pattern = processData.getItemValueString("task");
            for (ItemCollection _invoice : invoices) {
                ItemCollection invoice = this.workflowService.getWorkItem(_invoice.getUniqueID());
                if (invoice == null) continue;
                String subModelVersion = invoice.getModelVersion();
                String subProcessID = "" + invoice.getTaskID();
                if (!Pattern.compile(model_pattern).matcher(subModelVersion).find() || !Pattern.compile(process_pattern).matcher(subProcessID).find()) continue;
                logger.finest("...... subprocess matches criteria.");
                if (processData.hasItem("items")) {
                    logger.warning("subprocess itemList is not supported by the SepaScheduler!");
                }
                try {
                    invoice.setEventID(Integer.valueOf(processData.getItemValueString("event")).intValue());
                }
                catch (NumberFormatException e) {
                    throw new ModelException("INVALID_MODEL_ENTRY", "unable to parse event '" + processData.getItemValueString("event") + "'. Please check your model definition '" + invoice.getModelVersion() + "'!", (Exception)e);
                }
                invoice = this.workflowService.processWorkItem(invoice);
                this.logMessage("...invoice " + _invoice.getUniqueID() + " processed.", configuration, null);
            }
        }
    }

    public void logMessage(String message, ItemCollection configuration, ItemCollection workitem) {
        if (configuration != null) {
            configuration.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        if (workitem != null) {
            workitem.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        logger.info(message);
    }

    public ItemCollection findDbtrOptionByPaymentType(String paymentType, ItemCollection configuration) {
        if (paymentType == null) {
            return null;
        }
        ArrayList<ItemCollection> dbtrList = new ArrayList<ItemCollection>();
        List mapItems = configuration.getItemValue(ITEM_DBTR_CONFIG);
        for (Object mapOderItem : mapItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            dbtrList.add(itemCol);
        }
        for (ItemCollection dbtr : dbtrList) {
            if (!paymentType.equals(dbtr.getItemValueString("name"))) continue;
            return dbtr;
        }
        return null;
    }
}

