/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.adapter;

import jakarta.ejb.EJB;
import jakarta.inject.Inject;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.sepa.services.SepaWorkflowService;

public class SEPAExportAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(SEPAExportAdapter.class.getName());
    public static final String ERROR_CONFIG = "CONFIG_ERROR";
    public static final String ERROR_MISSING_INVOICE = "ERROR_MISSING_INVOICE";
    @EJB
    ReportService reportService;
    @Inject
    SepaWorkflowService sepaWorkflowService;

    public ItemCollection execute(ItemCollection sepaExport, ItemCollection event) throws AdapterException, PluginException {
        String key = sepaExport.getItemValueString("name");
        ItemCollection report = this.reportService.findReport(event.getItemValueString("txtReportName"));
        if (report == null) {
            throw new PluginException(SEPAExportAdapter.class.getName(), "REPORT_ERROR", "Missing report definition. Unable to load report '" + event.getItemValueString("txtReportName") + "'. Please check  model configuration ");
        }
        List refList = sepaExport.getItemValue("$workitemref");
        ArrayList<ItemCollection> data = new ArrayList<ItemCollection>();
        ItemCollection configuration = this.sepaWorkflowService.loadConfiguration();
        logger.info("...SEPA export started - " + refList.size() + " invoices found...");
        for (String ref : refList) {
            ItemCollection invoice = this.sepaWorkflowService.loadInvoice(ref);
            if (invoice == null) {
                logger.warning("Invoice '" + ref + "' not found! SEPA Export can not be executed");
                continue;
            }
            invoice = this.sepaWorkflowService.harmonizeSEPAItem(invoice, "cdtr.name");
            invoice = this.sepaWorkflowService.harmonizeSEPAItem(invoice, "dbtr.name");
            data.add(invoice);
        }
        data.add(sepaExport);
        String sDepName = sepaExport.getItemValueString("dbtr.name");
        sDepName = sDepName.replace("&", "_");
        sDepName = sDepName.replace(">", "_");
        sDepName = sDepName.replace("<", "_");
        sDepName = sDepName.replace(" ", "_");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HHmm");
        String sepaFileName = "sepa_" + sDepName + "_" + df.format(new Date()) + ".xml";
        try {
            FileData filedata = null;
            String optionalSepaReport = sepaExport.getItemValueString("sepa.report");
            ItemCollection reportOptional = this.reportService.findReport(optionalSepaReport);
            if (reportOptional != null) {
                filedata = this.reportService.transformDataSource(reportOptional, data, sepaFileName);
                this.sepaWorkflowService.logMessage("...SEPA export report=" + sepaExport.getItemValueString("sepa.report"), configuration, sepaExport);
            } else {
                if (!optionalSepaReport.isEmpty()) {
                    this.sepaWorkflowService.logMessage("...WARNING - SEPA export report " + optionalSepaReport + " not found! Default report will be used.", configuration, sepaExport);
                }
                filedata = this.reportService.transformDataSource(report, data, sepaFileName);
            }
            sepaExport.addFileData(filedata);
        }
        catch (JAXBException | IOException | TransformerException e) {
            throw new PluginException(SEPAExportAdapter.class.getName(), "REPORT_ERROR", "Failed to generate SEPA File:" + e.getMessage());
        }
        logger.info("...SEPA export " + key + "  finished.");
        return sepaExport;
    }
}

