/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.adapter;

import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.sepa.services.SepaWorkflowService;

public class SEPARefAddAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(SEPARefAddAdapter.class.getName());
    public static final String ERROR_CONFIG = "CONFIG_ERROR";
    @Inject
    SepaWorkflowService sepaWorkflowService;
    @Inject
    WorkflowService workflowService;
    int invoicesMaxCount = 0;
    int invoicesMaxCountEvent = 0;

    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        ItemCollection sepaConfig = this.workflowService.evalWorkflowResult(event, "sepa-export", workitem, true);
        if (sepaConfig != null) {
            logger.fine("read max count configuration from event");
            if (sepaConfig.getItemValueInteger("maxcount") > 0) {
                this.invoicesMaxCount = sepaConfig.getItemValueInteger("maxcount");
                this.invoicesMaxCountEvent = sepaConfig.getItemValueInteger("maxcount-event");
            }
        }
        String type = "OUT";
        if (sepaConfig != null && !sepaConfig.isItemEmpty("type")) {
            type = sepaConfig.getItemValueString("type");
        }
        if ("OUT".equalsIgnoreCase(type)) {
            this.sepaWorkflowService.updateDbtrDefaultData(workitem);
            this.sepaWorkflowService.validateCdtrData(workitem);
        } else {
            this.sepaWorkflowService.updateCdtrDefaultData(workitem);
            this.sepaWorkflowService.validateDbtrData(workitem);
        }
        String key = this.sepaWorkflowService.computeKey(workitem, event);
        logger.info("......Update SEPA export for: '" + key + "'...");
        try {
            List refList;
            ItemCollection sepaExport = this.sepaWorkflowService.findSEPAExportByTask(key, 1000);
            if (sepaExport == null) {
                sepaExport = this.sepaWorkflowService.createNewSEPAExport(key, workitem, event);
            }
            if (!(refList = sepaExport.getItemValue("$workitemref")).contains(workitem.getUniqueID())) {
                sepaExport.appendItemValueUnique("$workitemref", (Object)workitem.getUniqueID());
                sepaExport.event(100);
                this.sepaWorkflowService.processSEPAExport(sepaExport);
                if (this.invoicesMaxCount > 0 && sepaExport.getItemValue("$workitemref").size() >= this.invoicesMaxCount) {
                    logger.info("......Max Count of " + this.invoicesMaxCount + " invoices reached, executing maxcount-event=" + this.invoicesMaxCountEvent);
                    sepaExport.event(this.invoicesMaxCountEvent);
                    this.sepaWorkflowService.processSEPAExport(sepaExport);
                }
            }
        }
        catch (AccessDeniedException | ModelException | ProcessingErrorException | QueryException e1) {
            throw new PluginException(SEPARefAddAdapter.class.getName(), "MISSING_DATA", "Unable to add Invoice to SEPA Export: " + e1.getMessage());
        }
        return workitem;
    }
}

