/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.controller;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.faces.view.ViewScoped;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.scheduler.SchedulerController;
import org.imixs.workflow.engine.scheduler.SchedulerService;
import org.imixs.workflow.sepa.services.SepaScheduler;

@Named
@ViewScoped
public class SepaController
extends SchedulerController {
    private static final long serialVersionUID = 1L;
    protected List<ItemCollection> dbtrList = null;
    protected List<ItemCollection> cdtrList = null;
    @EJB
    SchedulerService schedulerService;
    @EJB
    DocumentService documentService;
    private static Logger logger = Logger.getLogger(SepaController.class.getName());

    @PostConstruct
    public void init() {
        super.init();
        this.loadDbtrCdtrListFromConfiguration();
    }

    public String getName() {
        return "SEPA_CONFIGURATION";
    }

    public String getSchedulerClass() {
        return SepaScheduler.class.getName();
    }

    public double calculateSum(List<String> refids, String item) {
        double result = 0.0;
        for (String id : refids) {
            ItemCollection doc = this.documentService.load(id);
            if (doc != null) {
                result += doc.getItemValueDouble(item);
                continue;
            }
            logger.warning("invalid read access to calculate sepa sum");
        }
        return (double)Math.round(result * 100.0) / 100.0;
    }

    public void loadDbtrCdtrListFromConfiguration() {
        ItemCollection itemCol;
        this.dbtrList = new ArrayList<ItemCollection>();
        List mapItems = this.getConfiguration().getItemValue("dbtr.config");
        for (Object mapOderItem : mapItems) {
            if (!(mapOderItem instanceof Map)) continue;
            itemCol = new ItemCollection((Map)mapOderItem);
            this.dbtrList.add(itemCol);
        }
        if (this.dbtrList.size() == 0 && this.getConfiguration().hasItem("_dbtr_name")) {
            logger.info("...migrate deprecated sepa configuration..");
            ItemCollection dbtr = new ItemCollection();
            dbtr.setItemValue("dbtr.name", (Object)this.getConfiguration().getItemValue("_dbtr_name"));
            dbtr.setItemValue("dbtr.iban", (Object)this.getConfiguration().getItemValue("_dbtr_iban"));
            dbtr.setItemValue("dbtr.bic", (Object)this.getConfiguration().getItemValue("_dbtr_bic"));
            dbtr.setItemValue("name", (Object)"SEPA");
            this.dbtrList.add(dbtr);
            this.getConfiguration().removeItem("_dbtr_name");
            this.getConfiguration().removeItem("_dbtr_iban");
            this.getConfiguration().removeItem("_dbtr_bic");
        }
        this.cdtrList = new ArrayList<ItemCollection>();
        mapItems = this.getConfiguration().getItemValue("cdtr.config");
        for (Object mapOderItem : mapItems) {
            if (!(mapOderItem instanceof Map)) continue;
            itemCol = new ItemCollection((Map)mapOderItem);
            this.cdtrList.add(itemCol);
        }
    }

    public void saveConfiguration() {
        ArrayList<Map> mapItemList;
        ItemCollection config = this.getConfiguration();
        if (this.dbtrList != null) {
            mapItemList = new ArrayList<Map>();
            logger.fine("Convert option items into Map...");
            for (ItemCollection dbtrItem : this.dbtrList) {
                mapItemList.add(dbtrItem.getAllItems());
            }
            config.replaceItemValue("dbtr.config", mapItemList);
        }
        if (this.cdtrList != null) {
            mapItemList = new ArrayList();
            logger.fine("Convert option items into Map...");
            for (ItemCollection cdtrItem : this.cdtrList) {
                mapItemList.add(cdtrItem.getAllItems());
            }
            config.replaceItemValue("cdtr.config", mapItemList);
        }
        super.saveConfiguration();
    }

    public List<ItemCollection> getDbtrList() {
        return this.dbtrList;
    }

    public List<ItemCollection> getCdtrList() {
        return this.cdtrList;
    }

    public void addDbtr() {
        if (this.dbtrList == null) {
            this.dbtrList = new ArrayList<ItemCollection>();
        }
        ItemCollection source = new ItemCollection();
        this.dbtrList.add(source);
    }

    public void addCdtr() {
        if (this.cdtrList == null) {
            this.cdtrList = new ArrayList<ItemCollection>();
        }
        ItemCollection source = new ItemCollection();
        this.cdtrList.add(source);
    }

    public void removeDbtr(String name) {
        if (name != null && this.dbtrList != null) {
            for (ItemCollection dbtr : this.dbtrList) {
                if (!name.equals(dbtr.getItemValueString("name"))) continue;
                this.dbtrList.remove(dbtr);
                break;
            }
        }
    }

    public void removeCdtr(String name) {
        if (name != null && this.cdtrList != null) {
            for (ItemCollection cdtr : this.cdtrList) {
                if (!name.equals(cdtr.getItemValueString("name"))) continue;
                this.cdtrList.remove(cdtr);
                break;
            }
        }
    }
}

