/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.adapter;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.sepa.services.SepaWorkflowService;

public class SEPARefFinishAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(SEPARefFinishAdapter.class.getName());
    public static final String ERROR_CONFIG = "CONFIG_ERROR";
    public static final String ERROR_MISSING_INVOICE = "ERROR_MISSING_INVOICE";
    @Inject
    SepaWorkflowService sepaWorkflowService;
    @Inject
    WorkflowService workflowService;

    public ItemCollection execute(ItemCollection sepaExport, ItemCollection event) throws AdapterException, PluginException {
        logger.info("...SEPA finish adapter started");
        List refList = sepaExport.getItemValue("$workitemref");
        ArrayList<ItemCollection> data = new ArrayList<ItemCollection>();
        for (String ref : refList) {
            ItemCollection invoice = this.sepaWorkflowService.loadInvoice(ref);
            if (invoice == null) {
                logger.warning("Invoice '" + ref + "' not found! Invoice can not be close");
                continue;
            }
            data.add(invoice);
        }
        logger.info("...SEPA finish start processing - " + data.size() + " invoices...");
        try {
            this.sepaWorkflowService.processInvoices(sepaExport, data, event, null);
        }
        catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_INVOICE, "Invalid Data - invoice list could not be processed !");
        }
        return sepaExport;
    }
}

