/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.adapter;

import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.sepa.services.SepaWorkflowService;

public class SEPARefRemoveAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(SEPARefRemoveAdapter.class.getName());
    public static final String ERROR_MISSING_DATA = "MISSING_DATA";
    public static final String ERROR_CONFIG = "CONFIG_ERROR";
    @Inject
    SepaWorkflowService sepaWorkflowService;

    public ItemCollection execute(ItemCollection invoice, ItemCollection event) throws AdapterException, PluginException {
        String key = this.sepaWorkflowService.computeKey(invoice, event);
        try {
            ItemCollection sepaExport = this.sepaWorkflowService.findSEPAExport(key);
            if (sepaExport != null) {
                logger.fine("......Update SEPA export for: '" + key + "'...");
                List refList = sepaExport.getItemValue("$workitemref");
                if (refList.contains(invoice.getUniqueID())) {
                    refList.remove(invoice.getUniqueID());
                    sepaExport.setItemValue("$workitemref", (Object)refList);
                    sepaExport.event(200);
                    this.sepaWorkflowService.processSEPAExport(sepaExport);
                }
            }
        }
        catch (AccessDeniedException | ModelException | ProcessingErrorException | QueryException e1) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "SEPA Export not found: " + e1.getMessage());
        }
        return invoice;
    }
}

