/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.plugins;

import jakarta.inject.Inject;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.iban4j.BicFormatException;
import org.iban4j.BicUtil;
import org.iban4j.IbanFormat;
import org.iban4j.IbanFormatException;
import org.iban4j.IbanUtil;
import org.iban4j.InvalidCheckDigitException;
import org.iban4j.UnsupportedCountryException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.faces.util.ResourceBundleHandler;

public class IBANBICPlugin
extends AbstractPlugin {
    public static final String ERROR_INVALID_IBANBIC = "ERROR_INVALID_IBANBIC";
    public static final String SEPA_VALIDATION_STRICT = "SEPA_VALIDATION_STRICT";
    public static final String[] IBAN_BIC_ITEMS = new String[]{"dbtr.iban", "cdtr.iban", "cdtr.bic", "dbtr.bic"};
    public static final String[] IBAN_ITEMS = new String[]{"dbtr.iban", "cdtr.iban"};
    public static final String[] BIC_ITEMS = new String[]{"cdtr.bic", "dbtr.bic"};
    private static Logger logger = Logger.getLogger(IBANBICPlugin.class.getName());
    @Inject
    @ConfigProperty(name="SEPA_VALIDATION_STRICT", defaultValue="false")
    boolean sepaValidationStrict;
    @Inject
    ResourceBundleHandler resourceBundleHandler;

    public ItemCollection run(ItemCollection workitem, ItemCollection event) throws PluginException {
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(event, "validation", workitem);
        if (evalItemCollection != null && "false".equalsIgnoreCase(evalItemCollection.getItemValueString("required"))) {
            return workitem;
        }
        this.trimInput(workitem, IBAN_BIC_ITEMS);
        try {
            this.validateIBAN(workitem, "dbtr.iban", "cdtr.iban");
        }
        catch (IbanFormatException | InvalidCheckDigitException | UnsupportedCountryException e) {
            logger.warning("Invalid iban!");
            String message = this.resourceBundleHandler.get(ERROR_INVALID_IBANBIC);
            if (message == null || message.isEmpty()) {
                message = ERROR_INVALID_IBANBIC;
            }
            throw new PluginException(((Object)((Object)this)).getClass().getName(), ERROR_INVALID_IBANBIC, message);
        }
        try {
            this.validateBIC(workitem, "dbtr.bic", "cdtr.bic");
        }
        catch (BicFormatException | UnsupportedCountryException e) {
            logger.warning("Invalid bic!");
            String message = this.resourceBundleHandler.get(ERROR_INVALID_IBANBIC);
            if (message == null || message.isEmpty()) {
                message = ERROR_INVALID_IBANBIC;
            }
            throw new PluginException(((Object)((Object)this)).getClass().getName(), ERROR_INVALID_IBANBIC, message);
        }
        return workitem;
    }

    public void setSepaValidationStrict(boolean sepaValidationStrict) {
        this.sepaValidationStrict = sepaValidationStrict;
    }

    private void trimInput(ItemCollection workitem, String[] itemList) {
        for (String itemName : itemList) {
            String valueTrimed;
            String value = workitem.getItemValueString(itemName);
            if (value.equals(valueTrimed = value.trim())) continue;
            workitem.setItemValue(itemName, (Object)valueTrimed);
        }
    }

    public void validateIBAN(ItemCollection workitem, String ... itemNames) {
        for (String itemName : itemNames) {
            String iban = workitem.getItemValueString(itemName);
            if (iban.isEmpty()) continue;
            if (!this.sepaValidationStrict) {
                iban = iban.replaceAll("\\s+", "");
            }
            if (iban.contains(" ")) {
                IbanUtil.validate((String)iban, (IbanFormat)IbanFormat.Default);
                continue;
            }
            IbanUtil.validate((String)iban, (IbanFormat)IbanFormat.None);
        }
    }

    public void validateBIC(ItemCollection workitem, String ... itemNames) {
        for (String itemName : itemNames) {
            String bic = workitem.getItemValueString(itemName);
            if (bic.isEmpty()) continue;
            if (!this.sepaValidationStrict) {
                bic = bic.replaceAll("\\s+", "");
            }
            BicUtil.validate((String)bic);
        }
    }
}

