/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.sepa.services;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.util.XMLParser;
import org.openbpmn.bpmn.BPMNModel;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class SepaWorkflowService {
    public static final String SEPA_CONFIGURATION = "SEPA_CONFIGURATION";
    public static final String ERROR_MISSING_DATA = "MISSING_DATA";
    public static final int EVENT_START = 100;
    public static final int EVENT_SUCCESS = 200;
    public static final int EVENT_FAILED = 300;
    public static final int EVENT_ADD_REF = 100;
    public static final int EVENT_REMOVE_REF = 200;
    public static final String INVOICE_UPDATE = "invoice_update";
    public static final String LINK_PROPERTY = "";
    public static final String ITEM_MODEL_VERSION = "_model_version";
    public static final String ITEM_INITIAL_TASK = "_initial_task";
    public static final String ITEM_PAYMENT_TYPE = "payment.type";
    public static final String ITEM_SEPA_REPORT = "sepa.report";
    public static final String ITEM_DBTR_IBAN = "dbtr.iban";
    public static final String ITEM_DBTR_BIC = "dbtr.bic";
    public static final String ITEM_DBTR_NAME = "dbtr.name";
    public static final String ITEM_CDTR_IBAN = "cdtr.iban";
    public static final String ITEM_CDTR_BIC = "cdtr.bic";
    public static final String ITEM_CDTR_NAME = "cdtr.name";
    public static final String ITEM_DBTR_CONFIG = "dbtr.config";
    public static final String ITEM_CDTR_CONFIG = "cdtr.config";
    public static final String REPORT_ERROR = "REPORT_ERROR";
    @EJB
    WorkflowService workflowService = null;
    @EJB
    ModelService modelService;
    @Inject
    DocumentService documentService;
    private static Logger logger = Logger.getLogger(SepaWorkflowService.class.getName());

    public void processInvoices(ItemCollection sepaExport, List<ItemCollection> invoices, ItemCollection event, ItemCollection configuration) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        List subProcessDefinitions = null;
        ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, "sepa", sepaExport, false);
        if (evalItemCollection == null) {
            logger.warning("...expected sepa item in workflow result is missing - data will not be processed!");
            return;
        }
        subProcessDefinitions = evalItemCollection.getItemValue(INVOICE_UPDATE);
        if (subProcessDefinitions == null || subProcessDefinitions.size() == 0) {
            return;
        }
        for (String processValue : subProcessDefinitions) {
            ItemCollection processData;
            if (processValue.trim().isEmpty() || (processData = XMLParser.parseItemStructure((String)processValue)) == null) continue;
            String model_pattern = processData.getItemValueString("modelversion");
            String process_pattern = processData.getItemValueString("task");
            for (ItemCollection _invoice : invoices) {
                ItemCollection invoice = this.workflowService.getWorkItem(_invoice.getUniqueID());
                if (invoice == null) continue;
                String subModelVersion = invoice.getModelVersion();
                String subProcessID = LINK_PROPERTY + invoice.getTaskID();
                if (!Pattern.compile(model_pattern).matcher(subModelVersion).find() || !Pattern.compile(process_pattern).matcher(subProcessID).find()) continue;
                logger.finest("...... subprocess matches criteria.");
                if (processData.hasItem("items")) {
                    logger.warning("subprocess itemList is not supported by the SepaScheduler!");
                }
                try {
                    invoice.setEventID(Integer.valueOf(processData.getItemValueString("event")).intValue());
                }
                catch (NumberFormatException e) {
                    throw new ModelException("INVALID_MODEL_ENTRY", "unable to parse event '" + processData.getItemValueString("event") + "'. Please check your model definition '" + invoice.getModelVersion() + "'!", (Exception)e);
                }
                invoice = this.workflowService.processWorkItem(invoice);
                this.logMessage("...invoice " + _invoice.getUniqueID() + " processed.", configuration, null);
            }
        }
    }

    public void logMessage(String message, ItemCollection configuration, ItemCollection workitem) {
        if (configuration != null) {
            configuration.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        if (workitem != null) {
            workitem.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        logger.info(message);
    }

    public ItemCollection findBankDataByPaymentType(String paymentType, ItemCollection configuration, String configType) {
        if (paymentType == null) {
            return null;
        }
        ArrayList<ItemCollection> bankDataList = new ArrayList<ItemCollection>();
        List mapItems = configuration.getItemValue(configType);
        for (Object mapOderItem : mapItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            bankDataList.add(itemCol);
        }
        for (ItemCollection data : bankDataList) {
            if (!paymentType.equals(data.getItemValueString("name"))) continue;
            return data;
        }
        return null;
    }

    public String computeKey(ItemCollection invoice, ItemCollection event) throws PluginException {
        String key = null;
        ItemCollection sepaConfig = this.workflowService.evalWorkflowResult(event, "sepa-export", invoice, true);
        if (sepaConfig != null && sepaConfig.hasItem("key")) {
            logger.fine("read key information from event");
            key = sepaConfig.getItemValueString("key");
        } else {
            key = invoice.getItemValueString(ITEM_DBTR_IBAN);
        }
        if (key.isEmpty()) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "Invalid Data - item 'dbtr.iban' is missing or key definition is empty!");
        }
        return key;
    }

    public ItemCollection createNewSEPAExport(String key, ItemCollection workitem, ItemCollection event) throws ModelException, PluginException {
        String modelVersion = null;
        int taskID = -1;
        ItemCollection sepaConfig = this.workflowService.evalWorkflowResult(event, "sepa-export", workitem, true);
        if (sepaConfig != null && sepaConfig.hasItem("modelversion") && sepaConfig.hasItem("task")) {
            logger.fine("read model information from event");
            modelVersion = sepaConfig.getItemValueString("modelVersion");
            taskID = sepaConfig.getItemValueInteger("task");
        } else {
            logger.fine("read model information from configuration");
            ItemCollection configuration = this.loadConfiguration();
            if (configuration == null) {
                throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "Unable to load sepa configuration!");
            }
            modelVersion = configuration.getItemValueString(ITEM_MODEL_VERSION);
            taskID = configuration.getItemValueInteger(ITEM_INITIAL_TASK);
        }
        ItemCollection sepaExport = new ItemCollection().model(modelVersion).task(taskID);
        sepaExport.replaceItemValue("name", (Object)key);
        sepaExport.replaceItemValue("$created", (Object)new Date());
        sepaExport.replaceItemValue("$modified", (Object)new Date());
        sepaExport.setItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
        String type = "OUT";
        if (sepaConfig != null && !sepaConfig.isItemEmpty("type")) {
            type = sepaConfig.getItemValueString("type");
        }
        if ("OUT".equalsIgnoreCase(type)) {
            sepaExport.setItemValue(ITEM_DBTR_IBAN, (Object)workitem.getItemValue(ITEM_DBTR_IBAN));
            if (workitem.hasItem(ITEM_DBTR_NAME)) {
                sepaExport.setItemValue(ITEM_DBTR_NAME, (Object)workitem.getItemValue(ITEM_DBTR_NAME));
            }
            if (workitem.hasItem(ITEM_DBTR_BIC)) {
                sepaExport.setItemValue(ITEM_DBTR_BIC, (Object)workitem.getItemValue(ITEM_DBTR_BIC));
            }
        } else {
            sepaExport.setItemValue(ITEM_CDTR_IBAN, (Object)workitem.getItemValue(ITEM_CDTR_IBAN));
            if (workitem.hasItem(ITEM_CDTR_NAME)) {
                sepaExport.setItemValue(ITEM_CDTR_NAME, (Object)workitem.getItemValue(ITEM_CDTR_NAME));
            }
            if (workitem.hasItem(ITEM_CDTR_BIC)) {
                sepaExport.setItemValue(ITEM_CDTR_BIC, (Object)workitem.getItemValue(ITEM_CDTR_BIC));
            }
        }
        if (workitem.hasItem(ITEM_PAYMENT_TYPE)) {
            sepaExport.setItemValue(ITEM_PAYMENT_TYPE, (Object)workitem.getItemValue(ITEM_PAYMENT_TYPE));
        }
        if (workitem.hasItem(ITEM_SEPA_REPORT)) {
            sepaExport.setItemValue(ITEM_SEPA_REPORT, (Object)workitem.getItemValue(ITEM_SEPA_REPORT));
        }
        BPMNModel model = this.modelService.getModelManager().getModel(modelVersion);
        ItemCollection task = this.modelService.getModelManager().findTaskByID(model, taskID);
        String modelTaskGroupName = task.getItemValueString("txtworkflowgroup");
        sepaExport.setItemValue("$workflowgroup", (Object)modelTaskGroupName);
        logger.info("...created new SEPA export for iban=" + key + "...");
        return sepaExport;
    }

    public ItemCollection processSEPAExport(ItemCollection datevExport) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        return this.workflowService.processWorkItem(datevExport);
    }

    public ItemCollection findSEPAExportByTask(String key, int taskID) throws QueryException {
        Object query = LINK_PROPERTY;
        query = taskID <= 0 ? "(type:workitem) AND ($modelversion:sepa-export-manual*) AND (name:\"" + key + "\")" : "(type:workitem) AND ($taskid:" + taskID + ") AND ($modelversion:sepa-export-manual*) AND (name:\"" + key + "\")";
        List resultList = this.workflowService.getDocumentService().find((String)query, 1, 0, "$modified", true);
        if (resultList.size() > 0) {
            return (ItemCollection)resultList.get(0);
        }
        return null;
    }

    public void updateDbtrDefaultData(ItemCollection workitem) throws PluginException {
        String paymentType = workitem.getItemValueString("payment.out.type");
        if (paymentType.isEmpty()) {
            paymentType = workitem.getItemValueString(ITEM_PAYMENT_TYPE);
        }
        if (!paymentType.isEmpty() && (workitem.getItemValueString(ITEM_DBTR_IBAN).isEmpty() || workitem.getItemValueString(ITEM_DBTR_BIC).isEmpty())) {
            ItemCollection bankData = this.findBankDataByPaymentType(paymentType, this.loadConfiguration(), ITEM_DBTR_CONFIG);
            if (bankData != null) {
                workitem.setItemValue(ITEM_DBTR_IBAN, (Object)bankData.getItemValue(ITEM_DBTR_IBAN));
                workitem.setItemValue(ITEM_DBTR_BIC, (Object)bankData.getItemValue(ITEM_DBTR_BIC));
                workitem.setItemValue(ITEM_DBTR_NAME, (Object)bankData.getItemValue(ITEM_DBTR_NAME));
                workitem.setItemValue(ITEM_SEPA_REPORT, (Object)bankData.getItemValue(ITEM_SEPA_REPORT));
            } else {
                throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "No dbtr information found in '" + workitem.getUniqueID() + "' for payment.out.type='" + paymentType + "'. Missing SEPA configuration!");
            }
        }
    }

    public void validateCdtrData(ItemCollection workitem) throws PluginException {
        if (workitem.getItemValueString(ITEM_CDTR_IBAN).isEmpty() || workitem.getItemValueString(ITEM_CDTR_BIC).isEmpty()) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "No creditor information found for this transaction!");
        }
    }

    public void updateCdtrDefaultData(ItemCollection workitem) throws PluginException {
        String paymentType = workitem.getItemValueString("payment.in.type");
        if (paymentType.isEmpty()) {
            paymentType = workitem.getItemValueString(ITEM_PAYMENT_TYPE);
        }
        if (!paymentType.isEmpty() && (workitem.getItemValueString(ITEM_CDTR_IBAN).isEmpty() || workitem.getItemValueString(ITEM_CDTR_BIC).isEmpty())) {
            ItemCollection bankData = this.findBankDataByPaymentType(paymentType, this.loadConfiguration(), ITEM_CDTR_CONFIG);
            if (bankData != null) {
                workitem.setItemValue(ITEM_CDTR_IBAN, (Object)bankData.getItemValue(ITEM_CDTR_IBAN));
                workitem.setItemValue(ITEM_CDTR_BIC, (Object)bankData.getItemValue(ITEM_CDTR_BIC));
                workitem.setItemValue(ITEM_CDTR_NAME, (Object)bankData.getItemValue(ITEM_CDTR_NAME));
                workitem.setItemValue(ITEM_SEPA_REPORT, (Object)bankData.getItemValue(ITEM_SEPA_REPORT));
            } else {
                throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "No creditor information found for '" + paymentType + "' in SEPA configuration!");
            }
        }
    }

    public void validateDbtrData(ItemCollection workitem) throws PluginException {
        if (workitem.getItemValueString(ITEM_DBTR_IBAN).isEmpty() || workitem.getItemValueString(ITEM_DBTR_BIC).isEmpty()) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "No debitor information found for this transaction!");
        }
    }

    public ItemCollection findSEPAExport(String key) throws QueryException {
        return this.findSEPAExportByTask(key, -1);
    }

    public ItemCollection harmonizeSEPAItem(ItemCollection invoice, String itemName) {
        String value = null;
        value = invoice.getItemValueString(itemName);
        value = value.replace("&", " ");
        value = value.replace(">", " ");
        value = value.replace("<", " ");
        invoice.replaceItemValue(itemName, (Object)value);
        return invoice;
    }

    public ItemCollection loadConfiguration() {
        try {
            String sQuery = "(type:\"scheduler\" AND (name:\"SEPA_CONFIGURATION\" ) )";
            List col = this.documentService.find(sQuery, 1, 0);
            if (col.size() > 0) {
                ItemCollection configuration = (ItemCollection)col.iterator().next();
                return configuration;
            }
        }
        catch (QueryException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public ItemCollection loadInvoice(String ref) {
        return this.documentService.load(ref);
    }
}

