/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.wopi;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.jwt.JWTException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.faces.fileupload.FileUploadController;
import org.imixs.workflow.faces.util.ResourceBundleHandler;
import org.imixs.workflow.wopi.WopiAccessHandler;

@Named
@ConversationScoped
public class WopiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(WopiController.class.getName());
    public static final String ITEM_WOPI_AUTO_OPEN = "wopi.auto.open";
    public static final String WOPI_CONFIRM_CHANGES = "WOPI_CONFIRM_CHANGES";
    private String accessToken = null;
    private boolean enabled = false;
    @Inject
    @ConfigProperty(name="wopi.host.endpoint", defaultValue="none")
    String wopiHostEndpoint;
    @Inject
    @ConfigProperty(name="wopi.file.extensions", defaultValue=".odt,.doc,.docx,.docm,.rtf,.ods,.xls,.xlsx,.odp,.ppt,.pptx,.odg,.dxf,.emf,.wmf,.vsd,.vsdx")
    String wopiFileExtensions;
    @Inject
    @ConfigProperty(name="wopi.options", defaultValue="none")
    String wopiOptions;
    @Inject
    WopiAccessHandler wopiAccessHandler;
    @Inject
    ResourceBundleHandler resourceBundleHandler;
    @Inject
    FileUploadController fileUploadController;

    @PostConstruct
    void init() {
        if (this.wopiHostEndpoint != null && !"none".equals(ITEM_WOPI_AUTO_OPEN)) {
            this.enabled = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    private String generateAccessToken(String userid, String username) {
        if (this.accessToken != null) {
            return this.accessToken;
        }
        try {
            logger.finest("...... generating new access token");
            this.accessToken = this.wopiAccessHandler.generateAccessToken(userid, username);
        }
        catch (JWTException e) {
            logger.severe("Failed to generate access token: " + e.getMessage());
        }
        return this.accessToken;
    }

    public void clearAccessToken() {
        if (this.accessToken != null) {
            this.wopiAccessHandler.clearFileCache(this.accessToken);
        }
        this.accessToken = null;
    }

    public String getWopiAccessURL(String uniqueid, String file, String userid, String username) {
        if (!this.enabled) {
            return null;
        }
        Object baseURL = this.wopiAccessHandler.getClientEndpointByFilename(file);
        if (baseURL == null) {
            logger.warning("...no wopi client endpoint found!");
            return null;
        }
        if (((String)baseURL).indexOf("&<rs=") > -1) {
            baseURL = ((String)baseURL).substring(0, ((String)baseURL).indexOf("&<rs="));
        }
        if (this.wopiOptions != null && !"none".equals(this.wopiOptions)) {
            baseURL = (String)baseURL + "&" + this.wopiOptions;
        }
        String[] extensions = this.wopiFileExtensions.split(",");
        boolean supported = false;
        for (String ext : extensions) {
            if (!file.endsWith(ext)) continue;
            supported = true;
            break;
        }
        if (!supported) {
            logger.fine("...filextension '" + file + "' is not supported.");
            return null;
        }
        if (!((String)baseURL).contains("?")) {
            baseURL = (String)baseURL + "?";
        }
        if (!((String)baseURL).endsWith("?") && !((String)baseURL).endsWith("&")) {
            baseURL = (String)baseURL + "&";
        }
        String token = this.generateAccessToken(userid, username);
        baseURL = (String)baseURL + "WOPISrc=" + this.wopiHostEndpoint + uniqueid + "/files/" + file + "&access_token=" + token;
        logger.fine("WOP Access URL=" + (String)baseURL);
        return baseURL;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        if (workflowEvent == null || workflowEvent.getWorkitem() == null) {
            return;
        }
        int eventType = workflowEvent.getEventType();
        if (22 == eventType && this.getAccessToken() != null) {
            List<FileData> files = this.wopiAccessHandler.getAllFileData(this.getAccessToken());
            for (FileData fileData : files) {
                logger.info(".....updating " + fileData.getName() + "...");
                this.fileUploadController.addAttachedFile(fileData);
            }
            this.wopiAccessHandler.clearFileCache(this.accessToken);
            workflowEvent.getWorkitem().setItemValue(ITEM_WOPI_AUTO_OPEN, (Object)"");
        }
    }

    public String getConfirmMessage() {
        String message = this.resourceBundleHandler.get(WOPI_CONFIRM_CHANGES);
        if (message == null || message.isEmpty()) {
            message = WOPI_CONFIRM_CHANGES;
        }
        return message;
    }
}

