/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.wopi;

import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.archive.core.SnapshotService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.util.XMLParser;
import org.imixs.workflow.wopi.WopiTemplateAdapter;

public class WopiDocumentConverterAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(WopiDocumentConverterAdapter.class.getName());
    public static final String DOCUMENT_ERROR = "DOCUMENT_ERROR";
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    @Inject
    WorkflowService workflowService;
    @Inject
    SnapshotService snapshotService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException, PluginException {
        ItemCollection evalItemCollection = null;
        ArrayList<ItemCollection> wopiConverterConfigList = null;
        if (this.isDeprecatedConfiguration(document, event)) {
            logger.warning("WopiTemplateAdapter is using deprecated configuration! Please use <wopi-template> instead of <wopi-converter name='source-path'>  - see documentation for details!");
            evalItemCollection = this.workflowService.evalWorkflowResult(event, "wopi-converter", document, true);
            wopiConverterConfigList = new ArrayList<ItemCollection>();
            wopiConverterConfigList.add(evalItemCollection);
        } else {
            String workflowResult = event.getItemValueString("txtActivityResult");
            wopiConverterConfigList = XMLParser.parseTagList((String)workflowResult, (String)"wopi-converter");
        }
        if (wopiConverterConfigList == null || wopiConverterConfigList.size() == 0) {
            throw new ProcessingErrorException(WopiTemplateAdapter.class.getSimpleName(), CONFIG_ERROR, "missing wopi-converter configuraiton in BPMN event!");
        }
        for (ItemCollection wopiConverterConfig : wopiConverterConfigList) {
            if (!wopiConverterConfig.hasItem("api-endpoint")) {
                throw new PluginException(WopiDocumentConverterAdapter.class.getSimpleName(), CONFIG_ERROR, "Wopi-Converter Error: 'api-endpoint' is not defined in current BPMN configuration");
            }
            if (!wopiConverterConfig.hasItem("filename")) {
                throw new PluginException(WopiDocumentConverterAdapter.class.getSimpleName(), CONFIG_ERROR, "Wopi-Converter Error: 'filename' is not defined in current BPMN configuration");
            }
            Object apiEndpoint = wopiConverterConfig.getItemValueString("api-endpoint");
            String fileName = wopiConverterConfig.getItemValueString("filename");
            String convertTo = wopiConverterConfig.getItemValueString("convert-to");
            fileName = this.workflowService.adaptText(fileName, document);
            if (!((String)apiEndpoint).endsWith("/")) {
                apiEndpoint = (String)apiEndpoint + "/";
            }
            if (convertTo.isEmpty()) {
                convertTo = "pdf";
            }
            String uri = (String)apiEndpoint + convertTo;
            logger.info("WopiDocumentConverter: " + fileName + " => " + uri);
            FileData fileData = document.getFileData(fileName);
            if (fileData != null) {
                this.convertFile(fileData, document, uri);
                continue;
            }
            List fileNames = document.getFileNames();
            Pattern pattern = Pattern.compile(fileName);
            for (String aFileName : fileNames) {
                if (!pattern.matcher(aFileName).find() || (fileData = document.getFileData(aFileName)) == null) continue;
                this.convertFile(fileData, document, uri);
            }
        }
        return document;
    }

    void convertFile(FileData fileData, ItemCollection document, String uri) throws PluginException {
        if (fileData == null) {
            throw new PluginException(WopiDocumentConverterAdapter.class.getSimpleName(), CONFIG_ERROR, "Converter Error: invalid filedata!");
        }
        String fileName = fileData.getName();
        if (fileData.getContent() == null || fileData.getContent().length < 3) {
            fileData = this.snapshotService.getWorkItemFile(document.getUniqueID(), fileName);
        }
        try {
            FileData pdfFile = this.postDocumentData(uri, fileData);
            document.addFileData(pdfFile);
        }
        catch (IOException e) {
            throw new PluginException(WopiDocumentConverterAdapter.class.getSimpleName(), DOCUMENT_ERROR, "WopiDocumentConverter Error - failed to post document data: " + e.getMessage());
        }
    }

    private FileData postDocumentData(String url, FileData fileData) throws MalformedURLException, IOException {
        logger.finest("post " + fileData.getName() + " " + fileData.getContent().length + " bytes....");
        String fileName = fileData.getName();
        String boundary = Long.toHexString(System.currentTimeMillis());
        String CRLF = "\r\n";
        URLConnection connection = new URL(url).openConnection();
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        OutputStream output = connection.getOutputStream();
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output), true);
        writer.append("--" + boundary).append(CRLF);
        writer.append("Content-Disposition: form-data; name=\"binaryFile\"; filename=\"" + fileName + "\"").append(CRLF);
        writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append(CRLF);
        writer.append("Content-Transfer-Encoding: binary").append(CRLF);
        writer.append(CRLF).flush();
        output.write(fileData.getContent());
        output.flush();
        writer.append(CRLF).flush();
        writer.append("--" + boundary + "--").append(CRLF).flush();
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        int responseCode = httpConnection.getResponseCode();
        logger.finest("response code=" + responseCode);
        InputStream response = httpConnection.getInputStream();
        byte[] pdfData = WopiDocumentConverterAdapter.readAllBytes(response);
        logger.finest("read " + pdfData.length + " bytes");
        Object pdfFileName = fileName;
        pdfFileName = ((String)pdfFileName).substring(0, ((String)pdfFileName).lastIndexOf(".")) + ".pdf";
        FileData resultFileData = new FileData((String)pdfFileName, pdfData, "application/pdf", null);
        return resultFileData;
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bufLen = 4096;
        byte[] buf = new byte[4096];
        IOException exception = null;
        try {
            byte[] byArray;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int readLen;
                while ((readLen = inputStream.read(buf, 0, 4096)) != -1) {
                    outputStream.write(buf, 0, readLen);
                }
                byArray = outputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    exception = e;
                    throw e;
                }
            }
            outputStream.close();
            return byArray;
        }
        finally {
            if (exception == null) {
                inputStream.close();
            } else {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    exception.addSuppressed(e);
                }
            }
        }
    }

    private boolean isDeprecatedConfiguration(ItemCollection workitem, ItemCollection event) throws PluginException {
        String workflowResult = event.getItemValueString("txtActivityResult");
        return !workflowResult.contains("<wopi-converter>");
    }
}

