/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.wopi;

import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.util.XMLParser;
import org.imixs.workflow.wopi.TextBlockHelperService;

public class WopiTemplateAdapter
implements SignalAdapter {
    public static final String API_ERROR = "API_ERROR";
    public static String SNAPSHOTID = "$snapshotid";
    final String TYPE_TEXTBLOCK = "textblock";
    private static Logger logger = Logger.getLogger(WopiTemplateAdapter.class.getName());
    @Inject
    @ConfigProperty(name="wopi.templates", defaultValue="/tmp/wopi/templates/")
    String templatePath;
    @Inject
    private WorkflowService workflowService;
    @Inject
    private TextBlockHelperService textBlockHelperService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException {
        ItemCollection evalItemCollection = null;
        ArrayList<ItemCollection> officeTemplateConfigList = null;
        logger.finest("...running api adapter...");
        try {
            if (this.isDeprecatedConfiguration(document, event)) {
                logger.warning("WopiTemplateAdapter is using deprecated configuration! Please use <wopi-template> instead of <wopi-tempalte name='source-path'>  - see documentation for details!");
                evalItemCollection = this.workflowService.evalWorkflowResult(event, "wopi-template", document, false);
                officeTemplateConfigList = new ArrayList<ItemCollection>();
                officeTemplateConfigList.add(evalItemCollection);
            } else {
                String workflowResult = event.getItemValueString("txtActivityResult");
                officeTemplateConfigList = XMLParser.parseTagList((String)workflowResult, (String)"wopi-template");
            }
            if (officeTemplateConfigList == null || officeTemplateConfigList.size() == 0) {
                throw new ProcessingErrorException(WopiTemplateAdapter.class.getSimpleName(), API_ERROR, "missing wopi-template configuraiton in BPMN event!");
            }
            for (ItemCollection officeTemplateConfig : officeTemplateConfigList) {
                String sourcePath = officeTemplateConfig.getItemValueString("source-path");
                String targetName = officeTemplateConfig.getItemValueString("target-name");
                boolean autoOpen = officeTemplateConfig.getItemValueBoolean("auto-open");
                if (sourcePath.isEmpty()) {
                    throw new ProcessingErrorException(WopiTemplateAdapter.class.getSimpleName(), API_ERROR, "missing source-path definition!");
                }
                sourcePath = sourcePath.replace("textblock>", "textblockignore>");
                sourcePath = this.workflowService.adaptText(sourcePath, document);
                sourcePath = sourcePath.replace("textblockignore>", "textblock>");
                if (targetName.isEmpty()) {
                    throw new ProcessingErrorException(WopiTemplateAdapter.class.getSimpleName(), API_ERROR, "missing target-name definition!");
                }
                targetName = this.workflowService.adaptText(targetName, document);
                if (!this.templatePath.endsWith("/")) {
                    this.templatePath = this.templatePath + "/";
                }
                if (sourcePath.startsWith("/")) {
                    sourcePath = sourcePath.substring(1);
                }
                FileData fileData = null;
                fileData = sourcePath.startsWith("<textblock>") ? this.readFromTextblock(sourcePath) : this.readFromFilesystem(this.templatePath + sourcePath);
                if (fileData == null) continue;
                logger.info("...adding new fileData object: " + targetName);
                fileData.setName(targetName);
                document.addFileData(fileData);
                if (!autoOpen) continue;
                document.setItemValue("wopi.auto.open", (Object)targetName);
            }
        }
        catch (PluginException e) {
            logger.warning("Unable to parse item definitions for 'wopi-template', verify model - " + e.getMessage());
        }
        return document;
    }

    private FileData readFromFilesystem(String filePath) {
        boolean debug = logger.isLoggable(Level.FINE);
        Path filepath = Paths.get(filePath, new String[0]);
        if (debug) {
            logger.finest("......load office template from filepath=" + filepath);
        }
        try {
            byte[] content = Files.readAllBytes(filepath);
            FileData fileData = new FileData(filepath.getFileName().toString(), content, null, null);
            logger.finest("...read from Filesystem: " + filepath.getFileName().toString());
            return fileData;
        }
        catch (IOException e) {
            throw new ProcessingErrorException(WopiTemplateAdapter.class.getSimpleName(), API_ERROR, "...no file found in template path: " + filepath);
        }
    }

    private FileData readFromTextblock(String sourcePath) {
        String textblockName = XMLParser.findTagValue((String)sourcePath, (String)"textblock");
        if (textblockName != null && !textblockName.isEmpty()) {
            ItemCollection textBlockDocument = this.textBlockHelperService.loadTextBlock(textblockName);
            if (textBlockDocument != null) {
                List fileDataList;
                if (!"FILE".equals(textBlockDocument.getItemValueString("txtmode"))) {
                    throw new ProcessingErrorException(WopiTemplateAdapter.class.getSimpleName(), API_ERROR, "textblock '" + textblockName + "' is not defined as type FILE!");
                }
                ItemCollection snapshotWorkitem = this.workflowService.getDocumentService().load(textBlockDocument.getItemValueString(SNAPSHOTID));
                if (snapshotWorkitem != null) {
                    textBlockDocument = snapshotWorkitem;
                }
                if ((fileDataList = textBlockDocument.getFileData()) != null && fileDataList.size() > 0) {
                    FileData fileData = (FileData)fileDataList.get(0);
                    logger.finest("...read from TextBlock: " + fileData.getName());
                    return fileData;
                }
            } else {
                throw new ProcessingErrorException(WopiTemplateAdapter.class.getSimpleName(), API_ERROR, "textblock '" + textblockName + "' not found!");
            }
        }
        return null;
    }

    private boolean isDeprecatedConfiguration(ItemCollection workitem, ItemCollection event) throws PluginException {
        String workflowResult = event.getItemValueString("txtActivityResult");
        return !workflowResult.contains("<wopi-template>");
    }
}

