/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.wopi;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class TextBlockHelperService {
    @EJB
    private DocumentService documentService;
    @Resource
    SessionContext ctx;
    final String TYPE = "textblock";
    private static Logger logger = Logger.getLogger(TextBlockHelperService.class.getName());

    public ItemCollection loadTextBlock(String name) {
        ItemCollection textBlockItemCollection = null;
        textBlockItemCollection = this.documentService.load(name);
        if (textBlockItemCollection == null) {
            String sQuery = "(type:\"textblock\" AND txtname:\"" + name + "\")";
            try {
                List col = this.documentService.find(sQuery, 1, 0);
                if (col.size() > 0) {
                    textBlockItemCollection = (ItemCollection)col.iterator().next();
                } else {
                    logger.warning("Missing text-block : '" + name + "'");
                }
            }
            catch (QueryException e) {
                logger.warning("getTextBlock - invalid query: " + e.getMessage());
            }
        }
        if (textBlockItemCollection == null) {
            textBlockItemCollection = new ItemCollection();
            textBlockItemCollection.replaceItemValue("type", (Object)"textblock");
            textBlockItemCollection.replaceItemValue("txtname", (Object)name);
        }
        return textBlockItemCollection;
    }
}

