/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.wopi;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.jwt.HMAC;
import org.imixs.jwt.JWTBuilder;
import org.imixs.jwt.JWTException;
import org.imixs.jwt.JWTParser;
import org.imixs.workflow.FileData;
import org.imixs.workflow.WorkflowKernel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@ApplicationScoped
public class WopiAccessHandler {
    private String jwtPassword;
    private Map<String, String> extensions = null;
    private Map<String, String> mimeTypes = null;
    @Inject
    @ConfigProperty(name="wopi.discovery.endpoint")
    Optional<String> wopiDiscoveryEndpoint;
    @Inject
    @ConfigProperty(name="wopi.public.endpoint")
    Optional<String> wopiPublicEndpoint;
    @Inject
    @ConfigProperty(name="wopi.access.token.expiration", defaultValue="3600")
    long wopiAccessTokenExpiration;
    @Inject
    @ConfigProperty(name="wopi.file.cache", defaultValue="/tmp/wopi/")
    String wopiFileCache;
    private static Logger logger = Logger.getLogger(WopiAccessHandler.class.getName());

    @PostConstruct
    void init() {
        this.jwtPassword = WorkflowKernel.generateUniqueID();
        if (this.wopiDiscoveryEndpoint != null && this.wopiDiscoveryEndpoint.isPresent() && !this.wopiDiscoveryEndpoint.get().isEmpty()) {
            try {
                this.parseDiscoveryURL(this.wopiDiscoveryEndpoint.get());
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.severe("Failed to parse discovery endpoint '" + this.wopiDiscoveryEndpoint.get() + "' Error: " + e.getMessage());
                this.extensions = null;
                this.mimeTypes = null;
            }
        } else {
            logger.warning("...unable to parse discovery endpoint - parameter ' not provided!");
        }
    }

    public void cacheFileData(String accessToken, FileData fileData) throws IOException {
        if (!Files.exists(Paths.get(this.wopiFileCache, new String[0]), new LinkOption[0])) {
            logger.finest("...creating wopi cache folder '" + this.wopiFileCache + "'...");
            Files.createDirectories(Paths.get(this.wopiFileCache, new String[0]), new FileAttribute[0]);
        }
        Path filepath = this.getCacheFilePath(accessToken, fileData.getName());
        logger.finest("......cache filepath=" + String.valueOf(filepath));
        Files.write(filepath, fileData.getContent(), new OpenOption[0]);
        this.deleteFilesOlderThanNSeconds(this.wopiAccessTokenExpiration, this.wopiFileCache);
    }

    public FileData fetchFileData(String accessToken, String filename) {
        Path filepath = this.getCacheFilePath(accessToken, filename);
        logger.finest("......fetchData from filepath=" + String.valueOf(filepath));
        try {
            byte[] content = Files.readAllBytes(filepath);
            FileData fileData = new FileData(filename, content, null, null);
            return fileData;
        }
        catch (IOException e) {
            logger.finest("...no file found in cache: " + String.valueOf(filepath));
            return null;
        }
    }

    public List<FileData> getAllFileData(String accessToken) {
        ArrayList<FileData> result = new ArrayList<FileData>();
        if (accessToken == null || accessToken.isEmpty()) {
            return result;
        }
        Path searchPath = Paths.get(this.wopiFileCache, new String[0]);
        final String prafix = "" + accessToken.hashCode();
        logger.finest("......getAllFileData by prafix " + prafix);
        try {
            File dir = new File(searchPath.toString());
            File[] foundFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prafix);
                }
            });
            if (foundFiles == null) {
                return result;
            }
            for (File file : foundFiles) {
                byte[] content = Files.readAllBytes(Paths.get(this.wopiFileCache + file.getName(), new String[0]));
                String filename = file.getName();
                filename = filename.substring(prafix.length() + 1);
                logger.finest("......found cached file : " + filename);
                FileData fileData = new FileData(filename, content, null, null);
                result.add(fileData);
            }
        }
        catch (IOException e) {
            logger.severe("Failed to read file: " + e.getMessage());
        }
        return result;
    }

    public void clearFileCache(String accessToken) {
        if (accessToken == null || accessToken.isEmpty()) {
            return;
        }
        Path searchPath = Paths.get(this.wopiFileCache, new String[0]);
        final String prafix = "" + accessToken.hashCode();
        logger.finest("......clearFileCache by prafix " + prafix);
        try {
            File dir = new File(searchPath.toString());
            File[] foundFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prafix);
                }
            });
            if (foundFiles != null) {
                for (File file : foundFiles) {
                    Files.delete(Paths.get(this.wopiFileCache + file.getName(), new String[0]));
                }
            }
        }
        catch (IOException e) {
            logger.severe("..failed to delete file: " + e.getMessage());
        }
    }

    public String generateAccessToken(String userid, String username) throws JWTException {
        SecretKey secretKey = HMAC.createKey((String)"HmacSHA256", (byte[])this.jwtPassword.getBytes());
        Object payload = "{\"sub\":\"wopi-host\"";
        payload = (String)payload + ",\"userid\":\"" + userid + "\"";
        payload = (String)payload + ",\"username\":\"" + username + "\"";
        payload = (String)payload + "}";
        JWTBuilder builder = new JWTBuilder().setKey(secretKey).setPayload((String)payload);
        return builder.getToken();
    }

    public JsonObject validateAccessToken(String access_token) {
        if (access_token == null || access_token.isEmpty()) {
            logger.warning("...missing access_token!");
            return null;
        }
        access_token = this.purgeAccessToken(access_token);
        SecretKey secretKey = HMAC.createKey((String)"HmacSHA256", (byte[])this.jwtPassword.getBytes());
        try {
            String payload = new JWTParser().setKey(secretKey).setToken(access_token).verify().getPayload();
            JsonReader reader = Json.createReader((Reader)new StringReader(payload));
            JsonObject payloadObject = reader.readObject();
            JsonNumber jsonnumber = payloadObject.getJsonNumber("iat");
            long lIAT = jsonnumber.longValue();
            long lNow = new Date().getTime() / 1000L;
            long lTimout = lNow - this.wopiAccessTokenExpiration;
            if (lTimout > lIAT) {
                logger.warning("access_token has expired!");
                return null;
            }
            return payloadObject;
        }
        catch (JWTException e) {
            logger.severe("...invalid access_token: " + e.getMessage());
            return null;
        }
    }

    public String purgeAccessToken(String access_token) {
        if (access_token == null || access_token.isEmpty()) {
            return access_token;
        }
        if (access_token.contains("?")) {
            access_token = access_token.substring(0, access_token.indexOf("?"));
        }
        return access_token;
    }

    public String getClientEndpointByFilename(String filename) {
        String result = null;
        if (this.extensions == null) {
            this.init();
        }
        if (this.extensions != null && filename.contains(".")) {
            String ext = filename.substring(filename.lastIndexOf(46) + 1);
            result = this.extensions.get(ext);
        }
        return this.resolvePublicEndpoint(result);
    }

    public String getClientEndpointByMimeType(String mimeType) {
        String result = null;
        if (this.extensions == null) {
            this.init();
        }
        if (this.mimeTypes != null) {
            result = this.mimeTypes.get(mimeType);
        }
        return this.resolvePublicEndpoint(result);
    }

    private String resolvePublicEndpoint(String uri) {
        Object result = uri;
        if (this.wopiPublicEndpoint != null && this.wopiPublicEndpoint.isPresent() && !this.wopiPublicEndpoint.get().isEmpty()) {
            try {
                URL internalURL = new URL(uri);
                String internalFile = internalURL.getFile();
                String publicEndpoint = this.wopiPublicEndpoint.get();
                if (publicEndpoint.endsWith("/")) {
                    publicEndpoint = publicEndpoint.substring(0, publicEndpoint.length() - 1);
                }
                result = publicEndpoint + internalFile;
                logger.fine("resolved public Endpint: " + (String)result);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            logger.warning("...wopi.public.endpoint is not set - check configuration!");
        }
        return result;
    }

    void parseDiscoveryURL(String endpoint) throws MalformedURLException, SAXException, IOException, ParserConfigurationException {
        logger.info("...parsing wopi.discovery.endpoint: " + endpoint);
        if (endpoint.startsWith("http://")) {
            logger.fine("...WOPI Client is running without SSL - this is not recommended for production!");
        }
        this.extensions = new HashMap<String, String>();
        this.mimeTypes = new HashMap<String, String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new URL(endpoint).openStream());
            NodeList appList = doc.getElementsByTagName("app");
            for (int i = 0; i < appList.getLength(); ++i) {
                Node appNode = appList.item(i);
                if (appNode.getNodeType() != 1) continue;
                Element eElement = (Element)appNode;
                String appName = eElement.getAttribute("name");
                logger.finest("...app=" + appName);
                NodeList actionElements = eElement.getElementsByTagName("action");
                for (int j = 0; j < actionElements.getLength(); ++j) {
                    Node actionNode = actionElements.item(j);
                    if (actionNode.getNodeType() != 1) continue;
                    Element eActionElement = (Element)actionNode;
                    String actionExt = eActionElement.getAttribute("ext");
                    String actionName = eActionElement.getAttribute("name");
                    String actionurlsrc = eActionElement.getAttribute("urlsrc");
                    if (actionExt != null && !actionExt.isEmpty()) {
                        this.extensions.put(actionExt, actionurlsrc);
                        logger.finest("...ext=" + actionExt + " -> " + actionurlsrc);
                        continue;
                    }
                    if (!appName.contains("/")) continue;
                    this.mimeTypes.put(appName, actionurlsrc);
                    logger.finest("...mimetype=" + appName + " -> " + actionurlsrc);
                }
            }
        }
        catch (MalformedURLException e) {
            logger.warning(e.getMessage());
        }
    }

    private Path getCacheFilePath(String accessToken, String filename) {
        if (!this.wopiFileCache.endsWith("/")) {
            this.wopiFileCache = this.wopiFileCache + "/";
        }
        return Paths.get(this.wopiFileCache + accessToken.hashCode() + "_" + filename, new String[0]);
    }

    private void deleteFilesOlderThanNSeconds(long seconds, String dirPath) throws IOException {
        long cutOff = System.currentTimeMillis() - seconds * 1000L;
        Files.list(Paths.get(dirPath, new String[0])).filter(path -> {
            try {
                return Files.isRegularFile(path, new LinkOption[0]) && Files.getLastModifiedTime(path, new LinkOption[0]).to(TimeUnit.MILLISECONDS) < cutOff;
            }
            catch (IOException ex) {
                return false;
            }
        }).forEach(path -> {
            try {
                logger.info("...delete deprecated wopi file: " + String.valueOf(path));
                Files.delete(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

