/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.wopi;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.wopi.WopiAccessHandler;

@Stateless
@LocalBean
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Path(value="/wopi")
@Produces(value={"application/json"})
public class WopiHostService {
    @Context
    private HttpServletRequest servletRequest;
    private static Logger logger = Logger.getLogger(WopiHostService.class.getName());
    @Inject
    WopiAccessHandler wopiAccessHandler;
    @Inject
    DocumentService documentService;
    @Inject
    @ConfigProperty(name="wopi.postmessageorigin")
    Optional<String> postMessageOrigin;

    @GET
    @Path(value="/ping")
    public String ping() {
        String message = "wopi service ping: " + System.currentTimeMillis();
        logger.info(message);
        return message;
    }

    @GET
    @Path(value="/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}/files/{file}")
    @Produces(value={"application/json"})
    public Response getFileInfo(@PathParam(value="uniqueid") String uniqueid, @PathParam(value="file") String file, @QueryParam(value="access_token") String accessToken) {
        logger.info("......GET getFileInfo: " + uniqueid + "/" + file);
        accessToken = this.wopiAccessHandler.purgeAccessToken(accessToken);
        JsonObject acessTokenPayload = this.wopiAccessHandler.validateAccessToken(accessToken);
        if (acessTokenPayload == null) {
            logger.warning("...invalid access_token!");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection workitem = null;
        workitem = this.documentService.load(uniqueid);
        if (workitem == null) {
            logger.warning("wokitem '" + uniqueid + "' not found!");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        FileData fileData = null;
        fileData = this.loadFileData(uniqueid, file, accessToken);
        if (fileData == null) {
            logger.warning("wokitem '" + uniqueid + "' no fileData object not found!");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        JsonObjectBuilder builder = null;
        try {
            builder = this.buildJsonFileInfo(fileData, workitem.getItemValueDate("$modified"), acessTokenPayload);
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("unable to compute Sha256 from content: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        JsonObject result = builder.build();
        return Response.ok((Object)result.toString(), (String)"application/json").build();
    }

    @GET
    @Path(value="/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}/files/{file}/contents")
    public Response getFileContents(@PathParam(value="uniqueid") String uniqueid, @PathParam(value="file") String file, @QueryParam(value="access_token") String accessToken) {
        logger.info("......GET getFileContents: " + uniqueid + "/" + file);
        accessToken = this.wopiAccessHandler.purgeAccessToken(accessToken);
        JsonObject acessTokenPayload = this.wopiAccessHandler.validateAccessToken(accessToken);
        if (acessTokenPayload == null) {
            logger.warning("...invalid access_token!");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        FileData fileData = this.loadFileData(uniqueid, file, accessToken);
        if (fileData == null) {
            logger.warning("no file data found '" + uniqueid + "'!");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            logger.info("......sending " + fileData.getContent().length + " bytes...");
            Response.ResponseBuilder builder = Response.ok((Object)fileData.getContent(), (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment;filename=" + new String(file.getBytes("UTF-8"), "ISO-8859-1"))).header("Content-Length", (Object)fileData.getContent());
            return builder.status(Response.Status.OK).build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @POST
    @PUT
    @Path(value="/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}/files/{file}/contents")
    public Response postFileContents(@PathParam(value="uniqueid") String uniqueid, @PathParam(value="file") String file, InputStream contentStream, @QueryParam(value="access_token") String accessToken, @Context UriInfo info) {
        logger.info("......POST postFileContents: " + uniqueid + "/" + file);
        String wopiHeader = this.servletRequest.getHeader("X-LOOL-WOPI-IsExitSave");
        if (wopiHeader != null && "true".equalsIgnoreCase(wopiHeader)) {
            logger.info("...ignore X-LOOL-WOPI-IsExitSave = " + wopiHeader);
            return Response.ok().build();
        }
        JsonObject acessTokenPayload = this.wopiAccessHandler.validateAccessToken(accessToken = this.wopiAccessHandler.purgeAccessToken(accessToken));
        if (acessTokenPayload == null) {
            logger.warning("...invalid access_token!");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        FileData fileData = null;
        try {
            byte[] content = this.readAllBytes(contentStream);
            logger.finest("...receifed " + content.length + " bytes");
            fileData = new FileData(file, content, null, null);
            this.wopiAccessHandler.cacheFileData(accessToken, fileData);
        }
        catch (IOException e) {
            logger.warning("failed to cache document data: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        JsonObjectBuilder builder = null;
        try {
            builder = this.buildJsonFileInfo(fileData, new Date(), acessTokenPayload);
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("unable to compute Sha256 from content: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        JsonObject result = builder.build();
        return Response.ok((Object)result.toString(), (String)"application/json").build();
    }

    private FileData loadFileData(String uniqueid, String filename, String accessToken) {
        FileData result;
        if (accessToken != null && !accessToken.isEmpty() && (result = this.wopiAccessHandler.fetchFileData(accessToken, filename)) != null) {
            return result;
        }
        ItemCollection workitem = this.documentService.load(uniqueid);
        if (workitem == null) {
            return null;
        }
        result = workitem.getFileData(filename);
        if (result != null && result.getContent() != null && result.getContent().length > 3) {
            return result;
        }
        String snapshotID = workitem.getItemValueString("$snapshotid");
        ItemCollection snapshot = this.documentService.load(snapshotID);
        if (snapshot != null && (result = snapshot.getFileData(filename)) != null && result.getContent() != null && result.getContent().length > 3) {
            return result;
        }
        return null;
    }

    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bufLen = 4096;
        byte[] buf = new byte[4096];
        IOException exception = null;
        try {
            byte[] byArray;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int readLen;
                while ((readLen = inputStream.read(buf, 0, 4096)) != -1) {
                    outputStream.write(buf, 0, readLen);
                }
                byArray = outputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    exception = e;
                    throw e;
                }
            }
            outputStream.close();
            return byArray;
        }
        finally {
            if (exception == null) {
                inputStream.close();
            } else {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    exception.addSuppressed(e);
                }
            }
        }
    }

    private JsonObjectBuilder buildJsonFileInfo(FileData fileData, Date modified, JsonObject acessTokenPayload) throws NoSuchAlgorithmException {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("BaseFileName", fileData.getName());
        builder.add("Size", fileData.getContent().length);
        builder.add("OwnerId", acessTokenPayload.getString("userid"));
        builder.add("UserId", acessTokenPayload.getString("userid"));
        builder.add("UserFriendlyName", acessTokenPayload.getString("username"));
        builder.add("Version", modified.getTime());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        sdf.setTimeZone(TimeZone.getTimeZone("CET"));
        builder.add("LastModifiedTime", sdf.format(modified));
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(fileData.getContent());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            sb.append(Integer.toString((hash[i] & 0xFF) + 256, 16).substring(1));
        }
        builder.add("Sha256", sb.toString());
        builder.add("UserCanWrite", true);
        builder.add("SupportsUpdate", true);
        if (this.postMessageOrigin.isPresent() && !this.postMessageOrigin.get().isEmpty()) {
            logger.info("......setting postMessageOrigin=" + this.postMessageOrigin.get());
            builder.add("PostMessageOrigin", this.postMessageOrigin.get());
        }
        return builder;
    }
}

