/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ai.rest;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.ai.model.BPMNTemplateBuilder;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.ModelException;
import org.openbpmn.bpmn.BPMNModel;
import org.openbpmn.bpmn.exceptions.BPMNValidationException;

@Named
@RequestScoped
@Path(value="/ai/bpmn/template/")
@Produces(value={"application/json", "text/plain"})
public class BPMNTemplateRestService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(BPMNTemplateRestService.class.getSimpleName());
    @Context
    UriInfo uriInfo;
    @Inject
    WorkflowService workflowService;
    @Inject
    ModelService modelService;

    @GET
    @Path(value="/model/version/{version}")
    @Produces(value={"text/plain"})
    public Response buildPromptTemplate(@PathParam(value="version") String version) {
        if (version == null || version.trim().isEmpty()) {
            logger.warning("Version parameter is null or empty");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Version parameter is required").build();
        }
        try {
            BPMNModel model = this.workflowService.fetchModel(version);
            ModelManager modelManager = new ModelManager((WorkflowContext)this.workflowService);
            String template = BPMNTemplateBuilder.buildPromptTemplate(model, modelManager);
            if (template == null || template.trim().isEmpty()) {
                logger.warning("Template generation failed for version: " + version);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Template generation failed").build();
            }
            logger.fine("Successfully built template for version: " + version);
            return Response.ok((Object)template).build();
        }
        catch (ModelException | BPMNValidationException e) {
            logger.log(Level.SEVERE, "ModelException for version: " + version, e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Model error: " + e.getMessage())).build();
        }
    }
}

