/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ai.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.bpmn.BPMNEntityBuilder;
import org.imixs.workflow.bpmn.BPMNLinkedFlowIterator;
import org.imixs.workflow.bpmn.BPMNUtil;
import org.imixs.workflow.exceptions.ModelException;
import org.openbpmn.bpmn.BPMNModel;
import org.openbpmn.bpmn.elements.Event;
import org.openbpmn.bpmn.elements.core.BPMNElementNode;
import org.openbpmn.bpmn.exceptions.BPMNValidationException;

public class BPMNTemplateBuilder {
    private static Logger logger = Logger.getLogger(BPMNTemplateBuilder.class.getName());

    public static String buildPromptTemplate(BPMNModel model, ModelManager modelManager) throws ModelException, BPMNValidationException {
        StringBuffer buffer = new StringBuffer();
        ArrayList<Integer> allTaskIDs = new ArrayList<Integer>();
        Set groups = modelManager.findAllGroupsByModel(model);
        for (String group : groups) {
            buffer.append("Business Process: " + group + "\n\n");
            List startTasks = modelManager.findStartTasks(model, group);
            for (ItemCollection startTask : startTasks) {
                buffer.append("START\n  |\n");
                allTaskIDs.add(startTask.getItemValueInteger("taskid"));
                BPMNTemplateBuilder.printTask(model, startTask, buffer, modelManager);
            }
            List allTasks = modelManager.findTasks(model, group);
            for (ItemCollection task : allTasks) {
                int taskID;
                if (task.getItemValueString("txtType").endsWith("archive") || allTaskIDs.contains(taskID = task.getItemValueInteger("taskid"))) continue;
                allTaskIDs.add(taskID);
                BPMNTemplateBuilder.printTask(model, task, buffer, modelManager);
            }
            buffer.append(" END\n  |\n");
            for (ItemCollection task : allTasks) {
                int taskID;
                if (!task.getItemValueString("txtType").endsWith("archive") || allTaskIDs.contains(taskID = task.getItemValueInteger("taskid"))) continue;
                allTaskIDs.add(taskID);
                BPMNTemplateBuilder.printTask(model, task, buffer, modelManager);
            }
        }
        buffer.append("  \n");
        System.out.print(buffer.toString());
        return buffer.toString();
    }

    private static int printTask(BPMNModel model, ItemCollection task, StringBuffer buffer, ModelManager modelManager) throws BPMNValidationException {
        int taskID = task.getItemValueInteger("taskid");
        buffer.append("  |- [Task: " + taskID + "] " + task.getItemValueString("name") + "\n");
        String documentation = task.getItemValueString("documentation");
        if (!documentation.isEmpty() && !documentation.startsWith("<")) {
            buffer.append("  |  " + documentation + "\n");
        }
        List events = modelManager.findEventsByTask(model, taskID);
        Collections.sort(events, new ItemCollectionComparator("eventID", true));
        for (ItemCollection event : events) {
            String id = event.getItemValueString("id");
            Event eventElement = (Event)model.findElementNodeById(id);
            BPMNLinkedFlowIterator elementNavigator = new BPMNLinkedFlowIterator((BPMNElementNode)eventElement, node -> BPMNUtil.isImixsTaskElement((BPMNElementNode)node), null);
            if (!elementNavigator.hasNext()) continue;
            BPMNElementNode target = elementNavigator.next();
            ItemCollection targetItemCol = BPMNEntityBuilder.build((BPMNElementNode)target);
            buffer.append("  |   |-- [Event: " + event.getItemValueInteger("eventID") + "] " + event.getItemValueString("name") + " --> [Task: " + targetItemCol.getItemValueString("taskid") + "] " + targetItemCol.getItemValueString("name") + "\n");
        }
        buffer.append("  |\n");
        return taskID;
    }
}

