/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.core.cassandra;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.cassandra.ArchiveClientService;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.jpa.EventLog;

@Startup
@Singleton
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class ArchivePushService {
    private static final long INTERVAL = 1000L;
    @Inject
    @ConfigProperty(name="ARCHIVE_SERVICE_ENDPOINT", defaultValue="")
    String archiveServiceEndpoint;
    @Inject
    EventLogService eventLogService;
    @Inject
    ArchiveClientService archiveClientService;
    @Resource
    private TimerService timerService;
    private Timer timer;
    private ConcurrentLinkedQueue<EventLog> eventCache = null;
    private static Logger logger = Logger.getLogger(ArchivePushService.class.getName());

    @PostConstruct
    public void init() {
        this.eventCache = new ConcurrentLinkedQueue();
        if (this.archiveServiceEndpoint != null && !this.archiveServiceEndpoint.isEmpty()) {
            TimerConfig config = new TimerConfig();
            config.setPersistent(false);
            this.timer = this.timerService.createIntervalTimer(1000L, 1000L, config);
        }
    }

    @Timeout
    private synchronized void onTimer() {
        List events = this.eventLogService.findEventsByTopic(100, new String[]{"snapshot.add", "snapshot.remove"});
        this.clearCache(events);
        for (EventLog eventLogEntry : events) {
            if (!this.eventCache.contains(eventLogEntry)) {
                if (!"snapshot.add".equals(eventLogEntry.getTopic())) continue;
                logger.finest("......push snapshot " + eventLogEntry.getRef() + "....");
                this.eventCache.add(eventLogEntry);
                this.archiveClientService.pushSnapshot(eventLogEntry);
                continue;
            }
            logger.finest("......snapshot " + eventLogEntry.getId() + " was already fired but not yet done....");
        }
    }

    private void clearCache(List<EventLog> events) {
        if (events == null) {
            return;
        }
        for (EventLog eventLogEntry : this.eventCache) {
            if (events.contains(eventLogEntry)) continue;
            logger.info("removing " + eventLogEntry.getId() + " from cache...");
            this.eventCache.remove();
        }
    }
}

