/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.documents;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.engine.PropertyService;
import org.imixs.workflow.exceptions.PluginException;

@Stateless
public class TikaDocumentService {
    public static final String PLUGIN_ERROR = "PLUGIN_ERROR";
    public static final String ENV_TIKA_SERVICE_ENDPONT = "TIKA_SERVICE_ENDPONT";
    public static final String ENV_TIKA_SERVICE_MODE = "TIKA_SERVICE_MODE";
    private static Logger logger = Logger.getLogger(TikaDocumentService.class.getName());
    @EJB
    PropertyService propertyService;

    @PostConstruct
    public void init(WorkflowContext actx) throws PluginException {
    }

    public void onBeforeProcess(@Observes ProcessingEvent processingEvent) throws PluginException {
        String serviceMode = this.getEnv(ENV_TIKA_SERVICE_MODE, null);
        if ("auto".equalsIgnoreCase(serviceMode) && processingEvent.getEventType() == 1) {
            this.extractText(processingEvent.getDocument());
        }
    }

    public void extractText(ItemCollection workitem) throws PluginException {
        String serviceEndpoint = this.getEnv(ENV_TIKA_SERVICE_ENDPONT, null);
        if (serviceEndpoint == null) {
            return;
        }
        long l = System.currentTimeMillis();
        List files = workitem.getFileData();
        for (FileData fileData : files) {
            byte[] fileContent = fileData.getContent();
            if (!this.acceptContentType(fileData.getContentType()) || fileContent == null || fileContent.length <= 1) continue;
            try {
                logger.info("...send " + fileData.getName() + " to tika server...");
                String result = this.put(serviceEndpoint, fileContent, fileData.getContentType(), "UTF-8");
                if (result == null || result.isEmpty()) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.add(result);
                fileData.setAttribute("content", list);
            }
            catch (Exception e) {
                throw new PluginException(TikaDocumentService.class.getSimpleName(), PLUGIN_ERROR, "Unable to scan attached document '" + fileData.getName() + "'", e);
            }
        }
        logger.fine("...extracted textual information in " + (System.currentTimeMillis() - l) + "ms");
    }

    public String put(String uri, byte[] dataString, String contentType, String encoding) throws Exception {
        PrintWriter printWriter = null;
        if (contentType == null || contentType.isEmpty()) {
            contentType = "application/xml";
        }
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)new URL(uri).openConnection();
            urlConnection.setRequestMethod("PUT");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-Type", contentType + "; charset=" + encoding);
            urlConnection.setRequestProperty("Accept", "text/plain");
            urlConnection.setRequestProperty("Content-Length", "" + Integer.valueOf(dataString.length));
            OutputStream output = urlConnection.getOutputStream();
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, encoding), true);
            output.write(dataString);
            writer.flush();
            String sHTTPResponse = urlConnection.getHeaderField(0);
            int iLastHTTPResult = 0;
            try {
                iLastHTTPResult = Integer.parseInt(sHTTPResponse.substring(9, 12));
            }
            catch (Exception eNumber) {
                String string = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                return string;
            }
            if (iLastHTTPResult >= 200 && iLastHTTPResult <= 299) {
                String string = this.readResponse(urlConnection, encoding);
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception ioe) {
            throw ioe;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(URLConnection urlConnection, String encoding) throws IOException {
        logger.finest("......readResponse....");
        StringWriter writer = new StringWriter();
        try (BufferedReader in = null;){
            String inputLine;
            String sContentEncoding = urlConnection.getContentEncoding();
            if ((sContentEncoding == null || sContentEncoding.isEmpty()) && encoding != null && !encoding.isEmpty()) {
                sContentEncoding = encoding;
            }
            in = sContentEncoding != null && !sContentEncoding.isEmpty() ? new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), sContentEncoding)) : new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                logger.finest("......" + inputLine);
                writer.write(inputLine);
            }
        }
        return writer.toString();
    }

    public String getEnv(String env, String defaultValue) {
        logger.finest("......read env: " + env);
        String result = null;
        result = this.propertyService.getProperties().getProperty(env);
        if (result == null) {
            result = System.getenv(env);
        }
        if (result == null || result.isEmpty()) {
            result = defaultValue;
        }
        return result;
    }

    private boolean acceptContentType(String contentType) {
        if (contentType == null || contentType.isEmpty()) {
            return false;
        }
        return !"application/octet-stream".equalsIgnoreCase(contentType);
    }
}

