/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.documents;

import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.documents.TikaDocumentService;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class TikaPlugin
extends AbstractPlugin {
    public static final String PLUGIN_ERROR = "PLUGIN_ERROR";
    private static Logger logger = Logger.getLogger(TikaPlugin.class.getName());
    @EJB
    TikaDocumentService tikaDocumentService;
    @Inject
    @ConfigProperty(name="TIKA_SERVICE_MODE", defaultValue="auto")
    String serviceMode;

    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
        logger.finest("...... service mode = " + this.serviceMode);
    }

    public ItemCollection run(ItemCollection document, ItemCollection event) throws PluginException {
        if (!"auto".equalsIgnoreCase(this.serviceMode)) {
            this.tikaDocumentService.extractText(document);
        }
        return document;
    }
}

