/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.documents;

import java.util.logging.Logger;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.SnapshotService;
import org.imixs.archive.ocr.OCRService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;

public class OCRDocumentAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(OCRDocumentAdapter.class.getName());
    @Inject
    @ConfigProperty(name="tika.service.mode", defaultValue="auto")
    String serviceMode;
    @Inject
    OCRService ocrService;
    @Inject
    SnapshotService snapshotService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException {
        logger.info("......starting TikaDocumentAdapter mode=" + this.serviceMode);
        if ("model".equalsIgnoreCase(this.serviceMode)) {
            logger.finest("...running api adapter...");
            try {
                this.ocrService.extractText(document, this.snapshotService.findSnapshot(document));
            }
            catch (PluginException e) {
                throw new AdapterException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
            }
        } else {
            logger.warning("unexpected TIKA_SERVICE_MODE=" + this.serviceMode);
        }
        return document;
    }
}

