/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.documents;

import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.SnapshotService;
import org.imixs.archive.ocr.OCRService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.exceptions.PluginException;

@Stateless
public class OCRDocumentService {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String PLUGIN_ERROR = "PLUGIN_ERROR";
    public static final String ENV_TIKA_SERVICE_ENDPOINT = "tika.service.endpoint";
    public static final String ENV_TIKA_SERVICE_MODE = "tika.service.mode";
    public static final String ENV_TIKA_OCR_MODE = "tika.ocr.mode";
    private static Logger logger = Logger.getLogger(OCRDocumentService.class.getName());
    @Inject
    @ConfigProperty(name="tika.service.endpoint", defaultValue="")
    String serviceEndpoint;
    @Inject
    @ConfigProperty(name="tika.service.mode", defaultValue="auto")
    String serviceMode;
    @Inject
    SnapshotService snapshotService;
    @Inject
    OCRService ocrService;

    public void onBeforeProcess(@Observes ProcessingEvent processingEvent) throws PluginException {
        if (this.serviceEndpoint == null || this.serviceEndpoint.isEmpty()) {
            return;
        }
        if ("auto".equalsIgnoreCase(this.serviceMode) && processingEvent.getEventType() == 1) {
            ItemCollection workitem = processingEvent.getDocument();
            this.ocrService.extractText(workitem, this.snapshotService.findSnapshot(workitem));
        }
    }
}

