/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.documents;

import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.SnapshotService;
import org.imixs.archive.documents.TikaService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class OCRDocumentPlugin
extends AbstractPlugin {
    private static Logger logger = Logger.getLogger(OCRDocumentPlugin.class.getName());
    @Inject
    TikaService ocrService;
    @Inject
    @ConfigProperty(name="ocr.service.mode", defaultValue="auto")
    String serviceMode;
    @Inject
    SnapshotService snapshotService;

    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
        logger.finest("...... service mode = " + this.serviceMode);
    }

    public ItemCollection run(ItemCollection document, ItemCollection event) throws PluginException {
        if ("model".equalsIgnoreCase(this.serviceMode)) {
            List tikaOptions = null;
            String filePattern = null;
            ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(event, "tika", document, false);
            if (evalItemCollection != null) {
                tikaOptions = evalItemCollection.getItemValue("options");
                filePattern = evalItemCollection.getItemValueString("filepattern");
            }
            this.ocrService.extractText(document, this.snapshotService.findSnapshot(document), null, tikaOptions, filePattern);
        } else {
            logger.warning("unexpected TIKA_SERVICE_MODE=" + this.serviceMode + " - running the OCRDocumentAdapter the env TIKA_SERVICE_MODE should be set to 'model'. Plugin will be ignored!");
        }
        return document;
    }
}

