/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.documents;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.index.IndexEvent;

@RequestScoped
public class DocumentIndexer {
    private static Logger logger = Logger.getLogger(DocumentIndexer.class.getName());

    public void onEvent(@Observes IndexEvent event) {
        List currentFileData = event.getDocument().getFileData();
        if (currentFileData == null || currentFileData.size() == 0) {
            return;
        }
        String textContent = event.getTextContent() + " ";
        for (FileData fileData : currentFileData) {
            logger.finest("......add text content for file " + fileData.getName());
            ItemCollection customAtributes = new ItemCollection(fileData.getAttributes());
            textContent = textContent + customAtributes.getItemValueString("text");
            textContent = textContent + " ";
        }
        event.setTextContent(textContent);
    }
}

