/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.documents;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.imixs.archive.core.SnapshotService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.util.XMLParser;

public class DocumentSplitAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(DocumentSplitAdapter.class.getName());
    public static final String LINK_PROPERTY = "$workitemref";
    public static final String SUBPROCESS_CREATE = "subprocess_create";
    public static final String DOCUMENTSPLIT = "DOCUMENTSPLIT";
    public static final String MODEL_ERROR = "MODEL_ERROR";
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    public static final String FILE_ERROR = "FILE_ERROR";
    @Inject
    WorkflowService workflowService;
    @Inject
    SnapshotService snapshotService;

    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        try {
            ItemCollection evalItemCollection = null;
            boolean debug = logger.isLoggable(Level.FINE);
            evalItemCollection = this.workflowService.evalWorkflowResult(event, "documentsplit", workitem, false);
            if (evalItemCollection == null) {
                return workitem;
            }
            if (evalItemCollection.hasItem(SUBPROCESS_CREATE)) {
                if (debug) {
                    logger.finest("......processing subprocess_create");
                }
                List processValueList = evalItemCollection.getItemValue(SUBPROCESS_CREATE);
                this.createSubprocesses(processValueList, workitem);
            }
        }
        catch (ModelException | ProcessingErrorException e) {
            String message = "unable to extract file data: " + e.getMessage();
            throw new PluginException(DOCUMENTSPLIT, MODEL_ERROR, message, (Exception)e);
        }
        return workitem;
    }

    protected void createSubprocesses(List<String> subProcessDefinitions, ItemCollection originWorkitem) throws PluginException, AccessDeniedException, ProcessingErrorException, ModelException {
        if (subProcessDefinitions == null || subProcessDefinitions.size() == 0) {
            return;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        for (String processValue : subProcessDefinitions) {
            Pattern filePattern;
            ItemCollection processData;
            if (processValue.trim().isEmpty() || (processData = XMLParser.parseItemStructure((String)processValue)) == null) continue;
            String filepatternString = processData.getItemValueString("filepattern");
            if (filepatternString.isEmpty()) {
                throw new PluginException(DOCUMENTSPLIT, MODEL_ERROR, "DocumentSplitAdapter - missing filepattern, please check workflow model!");
            }
            try {
                filePattern = Pattern.compile(filepatternString);
            }
            catch (PatternSyntaxException e) {
                throw new PluginException(DOCUMENTSPLIT, CONFIG_ERROR, "Invalid filepattern regex: " + e.getMessage());
            }
            List fileNames = originWorkitem.getFileNames();
            int count = 0;
            for (String fileName : fileNames) {
                Matcher fileMatcher = filePattern.matcher(fileName);
                if (fileMatcher == null || !fileMatcher.find()) continue;
                ++count;
                if (debug) {
                    logger.info("....split filename " + fileName);
                }
                this.processSubWorkitem(processData, originWorkitem, fileName);
            }
            if (count != 0) continue;
            throw new PluginException(DOCUMENTSPLIT, FILE_ERROR, "DocumentSplitAdapter - no file found matching the given filepattern, please check workflow model!");
        }
    }

    private void processSubWorkitem(ItemCollection processData, ItemCollection originWorkitem, String filename) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        boolean debug = logger.isLoggable(Level.FINE);
        ItemCollection workitemSubProcess = new ItemCollection();
        this.copyItemList(processData.getItemValueString("items"), originWorkitem, workitemSubProcess);
        workitemSubProcess.removeItem("$workitemid");
        workitemSubProcess.removeItem("$uniqueid");
        workitemSubProcess.removeItem("$eventlog");
        workitemSubProcess.removeItem("txtworkflowhistory");
        workitemSubProcess.removeItem("$file");
        FileData snapshotFileData = this.snapshotService.getWorkItemFile(originWorkitem.getUniqueID(), filename);
        if (snapshotFileData == null) {
            throw new PluginException(DOCUMENTSPLIT, FILE_ERROR, "DocumentSplitAdapter - no snapshot filedata object found!");
        }
        workitemSubProcess.addFileData(snapshotFileData);
        String sModelVersion = processData.getItemValueString("modelversion");
        if (sModelVersion.isEmpty()) {
            sModelVersion = originWorkitem.getModelVersion();
        }
        workitemSubProcess.replaceItemValue("$modelversion", (Object)sModelVersion);
        String task_pattern = processData.getItemValueString("task");
        workitemSubProcess.setTaskID(Integer.valueOf(task_pattern).intValue());
        String event_pattern = processData.getItemValueString("event");
        workitemSubProcess.setEventID(Integer.valueOf(event_pattern).intValue());
        workitemSubProcess.replaceItemValue("$uniqueidref", (Object)originWorkitem.getUniqueID());
        workitemSubProcess = this.workflowService.processWorkItem(workitemSubProcess);
        if (debug) {
            logger.finest("...... successful created new subprocess.");
        }
        this.addWorkitemRef(workitemSubProcess.getUniqueID(), originWorkitem);
    }

    protected void copyItemList(String items, ItemCollection source, ItemCollection target) {
        if (items == null || items.isEmpty()) {
            target.copy(source);
            return;
        }
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            if (field.startsWith("(") && field.endsWith(")")) {
                Pattern itemPattern = Pattern.compile(field);
                Map map = source.getAllItems();
                for (String itemName : map.keySet()) {
                    if (!itemPattern.matcher(itemName).find()) continue;
                    target.replaceItemValue(itemName, (Object)source.getItemValue(itemName));
                }
                continue;
            }
            int pos = field.indexOf(124);
            if (pos > -1) {
                target.replaceItemValue(field.substring(pos + 1).trim(), (Object)source.getItemValue(field.substring(0, pos).trim()));
                continue;
            }
            target.replaceItemValue(field, (Object)source.getItemValue(field));
        }
    }

    protected void addWorkitemRef(String aUniqueID, ItemCollection workitem) {
        List refList;
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.fine("LinkController add workitem reference: " + aUniqueID);
        }
        if ((refList = workitem.getItemValue(LINK_PROPERTY)).size() == 1 && "".equals(refList.get(0))) {
            refList.remove(0);
        }
        if (refList.indexOf(aUniqueID) == -1) {
            refList.add(aUniqueID);
            workitem.replaceItemValue(LINK_PROPERTY, (Object)refList);
        }
    }
}

