/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.documents;

import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.SnapshotService;
import org.imixs.archive.documents.TikaService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.exceptions.PluginException;

@Stateless
public class OCRDocumentService {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String PLUGIN_ERROR = "PLUGIN_ERROR";
    private static Logger logger = Logger.getLogger(OCRDocumentService.class.getName());
    @Inject
    @ConfigProperty(name="ocr.service.endpoint")
    Optional<String> serviceEndpoint;
    @Inject
    @ConfigProperty(name="ocr.service.mode", defaultValue="auto")
    String serviceMode;
    @Inject
    SnapshotService snapshotService;
    @Inject
    TikaService ocrService;

    public void onBeforeProcess(@Observes ProcessingEvent processingEvent) throws PluginException {
        if (!this.serviceEndpoint.isPresent() || this.serviceEndpoint.get().isEmpty()) {
            return;
        }
        if ("auto".equalsIgnoreCase(this.serviceMode) && processingEvent.getEventType() == 1) {
            ItemCollection workitem = processingEvent.getDocument();
            this.ocrService.extractText(workitem, this.snapshotService.findSnapshot(workitem));
        }
    }
}

