/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.documents;

import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.imixs.archive.core.SnapshotService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EInvoiceAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(EInvoiceAdapter.class.getName());
    public static final String E_INVOICE_ENTITY = "ENTITY";
    public static final String FILE_ATTRIBUTE_XML = "xml";
    public static final String FILE_ATTRIBUTE_EINVOICE_TYPE = "einvoice.type";
    public static final String PARSING_EXCEPTION = "PARSING_EXCEPTION";
    public static final String PLUGIN_ERROR = "PLUGIN_ERROR";
    public static final String REPORT_ERROR = "REPORT_ERROR";
    private static final Pattern PDF_PATTERN = Pattern.compile(".[pP][dD][fF]$");
    private static final Pattern XML_PATTERN = Pattern.compile(".[xX][mM][lL]$");
    private static final Pattern ZIP_PATTERN = Pattern.compile(".[zZ][iI][pP]$");
    public static final Map<String, String> NAMESPACES = new HashMap<String, String>();
    public static String PROCESSING_ERROR;
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    private XPath xpath = null;
    private Document xmlDoc = null;
    @Inject
    DocumentService documentService;
    @Inject
    WorkflowService workflowService;
    @Inject
    SnapshotService snapshotService;

    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        List entityDefinitions = this.workflowService.evalWorkflowResultXML(event, "e-invoice", E_INVOICE_ENTITY, workitem, false);
        if (entityDefinitions != null && entityDefinitions.size() > 0) {
            FileData eInvoiceFileData = this.detectEInvoice(workitem);
            if (eInvoiceFileData == null) {
                logger.info("No e-invoice type detected.");
                return workitem;
            }
            String einvoiceType = EInvoiceAdapter.detectEInvoiceType(eInvoiceFileData);
            workitem.setItemValue(FILE_ATTRIBUTE_EINVOICE_TYPE, (Object)einvoiceType);
            logger.info("Detected e-invoice type: " + einvoiceType);
            this.readEInvoiceContent(eInvoiceFileData, entityDefinitions, workitem);
        }
        return workitem;
    }

    public FileData detectEInvoice(ItemCollection workitem) throws PluginException {
        FileData xmlFileData = this.getXMLFileData(workitem, PDF_PATTERN);
        if (xmlFileData != null) {
            this.analyzeXMLContent(xmlFileData);
            return xmlFileData;
        }
        xmlFileData = this.getXMLFileData(workitem, XML_PATTERN);
        if (xmlFileData != null) {
            this.analyzeXMLContent(xmlFileData);
            return xmlFileData;
        }
        xmlFileData = this.getXMLFromZip(workitem);
        if (xmlFileData != null) {
            this.analyzeXMLContent(xmlFileData);
            return xmlFileData;
        }
        return null;
    }

    public static String detectEInvoiceType(FileData fileData) throws PluginException {
        List list = (List)fileData.getAttribute(FILE_ATTRIBUTE_EINVOICE_TYPE);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0).toString();
    }

    private void storeXMLContent(FileData fileData, byte[] xmlData) {
        ArrayList<byte[]> list = (ArrayList<byte[]>)fileData.getAttribute(FILE_ATTRIBUTE_XML);
        if (list == null) {
            list = new ArrayList<byte[]>();
        }
        list.add(xmlData);
        fileData.setAttribute(FILE_ATTRIBUTE_XML, list);
    }

    public byte[] readXMLContent(FileData fileData) {
        List list = (List)fileData.getAttribute(FILE_ATTRIBUTE_XML);
        if (list != null) {
            return (byte[])list.get(0);
        }
        return null;
    }

    private FileData getXMLFromZip(ItemCollection workitem) throws PluginException {
        List filenames = workitem.getFileNames();
        for (String filename : filenames) {
            if (!ZIP_PATTERN.matcher(filename).find()) continue;
            logger.info("Extracting XML from ZIP file: " + filename);
            FileData fileData = workitem.getFileData(filename);
            byte[] fileContent = fileData.getContent();
            if (this.snapshotService != null) {
                FileData snapShotFileData = this.snapshotService.getWorkItemFile(workitem.getUniqueID(), filename);
                fileContent = snapShotFileData.getContent();
            }
            byte[] xmlData = this.extractXMLFromZip(fileContent);
            this.storeXMLContent(fileData, xmlData);
            return fileData;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] extractXMLFromZip(byte[] zipContent) {
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zipContent));){
            int len;
            ZipEntry entry;
            do {
                if ((entry = zis.getNextEntry()) == null) return null;
            } while (!entry.getName().toLowerCase().endsWith(".xml"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = zis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            logger.warning("Error extracting XML from ZIP: " + e.getMessage());
        }
        return null;
    }

    private String analyzeXMLContent(FileData fileData) {
        byte[] xmlData = this.readXMLContent(fileData);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xmlData));
            Element rootElement = doc.getDocumentElement();
            String rootNamespace = rootElement.getNamespaceURI();
            String rootLocalName = rootElement.getLocalName();
            if ("CrossIndustryInvoice".equals(rootLocalName) && "urn:un:unece:uncefact:data:standard:CrossIndustryInvoice:100".equals(rootNamespace)) {
                fileData.setAttribute(FILE_ATTRIBUTE_EINVOICE_TYPE, Arrays.asList("Factur-X/ZUGFeRD 2.0"));
                return "Factur-X/ZUGFeRD 2.0";
            }
            if ("Invoice".equals(rootLocalName) && rootNamespace.startsWith("urn:oasis:names:specification:ubl")) {
                fileData.setAttribute(FILE_ATTRIBUTE_EINVOICE_TYPE, Arrays.asList("Factur-X/UBL"));
                return "Factur-X/UBL";
            }
            return "unknown";
        }
        catch (Exception e) {
            logger.warning("Error analyzing XML content: " + e.getMessage());
            return "unknown";
        }
    }

    private FileData getXMLFileData(ItemCollection workitem, Pattern filePattern) throws PluginException {
        List filenames = workitem.getFileNames();
        for (String filename : filenames) {
            if (!filePattern.matcher(filename).find()) continue;
            logger.info("Extracting embedded XML from '" + filename + "'");
            FileData fileData = workitem.getFileData(filename);
            byte[] fileContent = fileData.getContent();
            if (this.snapshotService != null) {
                FileData snapShotFileData = this.snapshotService.getWorkItemFile(workitem.getUniqueID(), filename);
                fileContent = snapShotFileData.getContent();
            }
            byte[] xmlContent = null;
            if (filePattern == PDF_PATTERN) {
                xmlContent = this.getFirstEmbeddedXML(fileContent);
            }
            if (filePattern == XML_PATTERN) {
                xmlContent = fileContent;
            }
            if (xmlContent == null) continue;
            this.storeXMLContent(fileData, xmlContent);
            return fileData;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getFirstEmbeddedXML(byte[] content) {
        try (PDDocument doc = PDDocument.load((byte[])content);){
            PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(doc.getDocumentCatalog());
            PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
            if (efTree == null) return null;
            byte[] byArray = this.extractXMLFromNameTreeNode(efTree);
            return byArray;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to load embedded XML: " + e.getMessage(), e);
        }
        return null;
    }

    private byte[] extractXMLFromNameTreeNode(PDEmbeddedFilesNameTreeNode efTree) throws IOException {
        Map names = efTree.getNames();
        if (names != null) {
            return this.extractFirstXMLFile(names);
        }
        for (PDNameTreeNode node : efTree.getKids()) {
            byte[] result = this.extractFirstXMLFile(node.getNames());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private byte[] extractFirstXMLFile(Map<String, PDComplexFileSpecification> names) throws IOException {
        for (PDComplexFileSpecification fileSpec : names.values()) {
            PDEmbeddedFile embeddedFile;
            String filename = fileSpec.getFile();
            if (!XML_PATTERN.matcher(filename).find() || (embeddedFile = EInvoiceAdapter.getEmbeddedFile(fileSpec)) == null) continue;
            try (COSInputStream inStream = embeddedFile.createInputStream();){
                byte[] byArray = EInvoiceAdapter.streamToByteArray((InputStream)inStream);
                return byArray;
            }
        }
        return null;
    }

    private void readEInvoiceContent(FileData eInvoiceFileData, List<ItemCollection> entityDefinitions, ItemCollection workitem) {
        byte[] xmlData = this.readXMLContent(eInvoiceFileData);
        try {
            this.createXMLDoc(xmlData);
            for (ItemCollection entityDef : entityDefinitions) {
                if (entityDef.getItemValueString("name").isEmpty() || entityDef.getItemValueString("xpath").isEmpty()) {
                    logger.warning("Invalid entity definition: " + String.valueOf(entityDef));
                    continue;
                }
                String itemName = entityDef.getItemValueString("name");
                String xPathExpr = entityDef.getItemValueString("xpath");
                String itemType = entityDef.getItemValueString("type");
                this.readItem(workitem, xPathExpr, itemType, itemName);
            }
        }
        catch (Exception e) {
            logger.warning("Error analyzing XML content: " + e.getMessage());
        }
    }

    private void createXPath() {
        if (this.xpath == null) {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            this.xpath = xPathfactory.newXPath();
            this.xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    return NAMESPACES.get(prefix);
                }

                @Override
                public String getPrefix(String uri) {
                    return null;
                }

                @Override
                public Iterator<String> getPrefixes(String uri) {
                    return null;
                }
            });
        }
    }

    public void createXMLDoc(byte[] xmlData) throws PluginException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.xmlDoc = builder.parse(new ByteArrayInputStream(xmlData));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new PluginException(EInvoiceAdapter.class.getSimpleName(), PARSING_EXCEPTION, "Failed to parse XML Content: " + e.getMessage(), e);
        }
    }

    public void readItem(ItemCollection workitem, String xPathExpr, String itemType, String itemName) throws PluginException {
        if (this.xmlDoc == null) {
            logger.warning("Missing XML Doc !");
            return;
        }
        this.createXPath();
        XPathExpression expr = null;
        try {
            expr = this.xpath.compile(xPathExpr);
            if (expr != null) {
                String itemValue;
                Node node = (Node)expr.evaluate(this.xmlDoc, XPathConstants.NODE);
                String string = itemValue = node != null ? node.getTextContent() : null;
                if ("date".equalsIgnoreCase(itemType)) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                    try {
                        Date invoiceDate = formatter.parse(itemValue);
                        workitem.setItemValue(itemName, (Object)invoiceDate);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else if ("double".equalsIgnoreCase(itemType)) {
                    workitem.setItemValue(itemName, (Object)Double.parseDouble(itemValue));
                } else {
                    workitem.setItemValue(itemName, (Object)itemValue);
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new PluginException(EInvoiceAdapter.class.getSimpleName(), PARSING_EXCEPTION, "Error compiling XPath expression: " + xPathExpr + " - " + e.getMessage(), (Exception)e);
        }
    }

    private static byte[] streamToByteArray(InputStream ins) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((read = ins.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    private static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        if (fileSpec != null) {
            return fileSpec.getEmbeddedFileUnicode() != null ? fileSpec.getEmbeddedFileUnicode() : (fileSpec.getEmbeddedFileDos() != null ? fileSpec.getEmbeddedFileDos() : (fileSpec.getEmbeddedFileMac() != null ? fileSpec.getEmbeddedFileMac() : (fileSpec.getEmbeddedFileUnix() != null ? fileSpec.getEmbeddedFileUnix() : fileSpec.getEmbeddedFile())));
        }
        return null;
    }

    static {
        NAMESPACES.put("rsm", "urn:un:unece:uncefact:data:standard:CrossIndustryInvoice:100");
        NAMESPACES.put("ram", "urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100");
        NAMESPACES.put("udt", "urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100");
        PROCESSING_ERROR = "PROCESSING_ERROR";
    }
}

