/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.documents;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Logger;
import org.imixs.archive.documents.EInvoiceAdapter;
import org.imixs.einvoice.EInvoiceFormatException;
import org.imixs.einvoice.EInvoiceModel;
import org.imixs.einvoice.EInvoiceModelFactory;
import org.imixs.einvoice.TradeParty;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;

public class EInvoiceAutoAdapter
extends EInvoiceAdapter {
    private static Logger logger = Logger.getLogger(EInvoiceAdapter.class.getName());

    @Override
    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        FileData eInvoiceFileData = this.detectEInvoice(workitem);
        if (eInvoiceFileData == null) {
            logger.fine("No e-invoice type detected.");
            return workitem;
        }
        String einvoiceType = EInvoiceAutoAdapter.detectEInvoiceType(eInvoiceFileData);
        workitem.setItemValue("einvoice.type", (Object)einvoiceType);
        logger.info("Detected e-invoice type: " + einvoiceType);
        byte[] xmlData = this.readXMLContent(eInvoiceFileData);
        try {
            EInvoiceModel model = EInvoiceModelFactory.read((InputStream)new ByteArrayInputStream(xmlData));
            this.resolveItemValues(workitem, model);
            String xmlText = new String(xmlData, StandardCharsets.UTF_8);
            eInvoiceFileData.setAttribute("text", Arrays.asList(xmlText));
        }
        catch (FileNotFoundException | EInvoiceFormatException e) {
            throw new AdapterException(EInvoiceAutoAdapter.class.getSimpleName(), EInvoiceFormatException.INVALID_FORMAT_EXCEPTION, "Failed to read E-Invoice: " + e.getMessage());
        }
        return workitem;
    }

    private void resolveItemValues(ItemCollection workitem, EInvoiceModel model) {
        workitem.setItemValue("invoice.number", (Object)model.getId());
        workitem.setItemValue("invoice.date", (Object)model.getIssueDateTime());
        workitem.setItemValue("invoice.duedate", (Object)model.getDueDateTime());
        workitem.setItemValue("invoice.total", (Object)model.getGrandTotalAmount().setScale(2, RoundingMode.HALF_UP));
        workitem.setItemValue("invoice.total.net", (Object)model.getNetTotalAmount().setScale(2, RoundingMode.HALF_UP));
        workitem.setItemValue("invoice.total.tax", (Object)model.getTaxTotalAmount().setScale(2, RoundingMode.HALF_UP));
        TradeParty seller = model.findTradeParty("seller");
        if (seller != null) {
            workitem.setItemValue("cdtr.name", (Object)seller.getName());
            workitem.setItemValue("cdtr.vatid", (Object)seller.getVatNumber());
        }
    }
}

