/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.documents;

import java.util.logging.Logger;
import org.imixs.archive.documents.EInvoiceAdapter;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;

public class EInvoiceMetaAdapter
extends EInvoiceAdapter {
    private static Logger logger = Logger.getLogger(EInvoiceAdapter.class.getName());

    @Override
    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        FileData eInvoiceFileData = this.detectEInvoice(workitem);
        if (eInvoiceFileData == null) {
            logger.info("No e-invoice type detected.");
            return workitem;
        }
        String einvoiceType = EInvoiceMetaAdapter.detectEInvoiceType(eInvoiceFileData);
        workitem.setItemValue("einvoice.type", (Object)einvoiceType);
        logger.info("Detected e-invoice type: " + einvoiceType);
        return workitem;
    }

    private void readEInvoiceContentNativeXML(FileData eInvoiceFileData, ItemCollection workitem) throws PluginException {
        byte[] xmlData = this.readXMLContent(eInvoiceFileData);
        logger.info("Autodetect e-invoice data...");
        this.createXMLDoc(xmlData);
        this.readItem(workitem, "//rsm:CrossIndustryInvoice/rsm:ExchangedDocument/ram:ID", "text", "invoice.number");
        this.readItem(workitem, "//rsm:ExchangedDocument/ram:IssueDateTime/udt:DateTimeString/text()", "date", "invoice.date");
        this.readItem(workitem, "//ram:SpecifiedTradeSettlementHeaderMonetarySummation/ram:GrandTotalAmount", "double", "invoice.total");
        this.readItem(workitem, "//ram:ApplicableHeaderTradeAgreement/ram:SellerTradeParty/ram:Name/text()", "text", "cdtr.name");
    }
}

